/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.email;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.graylog2.configuration.EmailConfiguration;

@Singleton
public class EmailFactory {
    private final EmailConfiguration configuration;

    @Inject
    public EmailFactory(EmailConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEmailTransportEnabled() {
        return this.configuration.isEnabled();
    }

    public SimpleEmail simpleEmail() throws EmailException {
        return this.getPreconfigured(SimpleEmail::new);
    }

    public MultiPartEmail multiPartEmail() throws EmailException {
        return this.getPreconfigured(MultiPartEmail::new);
    }

    public HtmlEmail htmlEmail() throws EmailException {
        return this.getPreconfigured(HtmlEmail::new);
    }

    public ImageHtmlEmail imageHtmlEmail() throws EmailException {
        return this.getPreconfigured(ImageHtmlEmail::new);
    }

    public <T extends Email> T getPreconfigured(Supplier<T> objectSupplier) throws EmailException {
        return (T)this.applyConfig((Email)objectSupplier.get());
    }

    private <T extends Email> T applyConfig(T email) throws EmailException {
        email.setCharset("utf-8");
        email.setHostName(this.configuration.getHostname());
        email.setSmtpPort(this.configuration.getPort());
        if (this.configuration.isUseSsl()) {
            email.setSslSmtpPort(Integer.toString(this.configuration.getPort()));
        }
        if (this.configuration.isUseAuth()) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(Strings.nullToEmpty((String)this.configuration.getUsername()), Strings.nullToEmpty((String)this.configuration.getPassword())));
        }
        email.setSSLOnConnect(this.configuration.isUseSsl());
        email.setStartTLSEnabled(this.configuration.isUseTls());
        if (!Strings.isNullOrEmpty((String)this.configuration.getFromEmail())) {
            email.setFrom(this.configuration.getFromEmail());
        }
        return email;
    }
}

