/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.plugins.views.search.views.ViewResolverDecoder;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.WidgetDTO;
import org.graylog.security.UserContext;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.dashboards.events.DashboardDeletedEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Views", tags={"cloud"})
@Path(value="/views")
@Produces(value={"application/json"})
@RequiresAuthentication
public class ViewsResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ViewsResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"summary", (Object)SearchQueryField.create("description")).build();
    private final ViewService dbService;
    private final SearchQueryParser searchQueryParser;
    private final ClusterEventBus clusterEventBus;
    private final SearchDomain searchDomain;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public ViewsResource(ViewService dbService, ClusterEventBus clusterEventBus, SearchDomain searchDomain, Map<String, ViewResolver> viewResolvers) {
        this.dbService = dbService;
        this.clusterEventBus = clusterEventBus;
        this.searchDomain = searchDomain;
        this.viewResolvers = viewResolvers;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @ApiOperation(value="Get a list of all views")
    public PaginatedResponse<ViewDTO> views(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="id,title,created_at") @DefaultValue(value="title") @QueryParam(value="sort") String sortField, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query, @Context SearchUser searchUser) {
        if (!ViewDTO.SORT_FIELDS.contains((Object)sortField.toLowerCase(Locale.ENGLISH))) {
            sortField = "title";
        }
        try {
            SearchQuery searchQuery = this.searchQueryParser.parse(query);
            PaginatedList<ViewDTO> result = this.dbService.searchPaginated(searchQuery, searchUser::canReadView, order, sortField, page, perPage);
            return PaginatedResponse.create("views", result, query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Get a single view")
    public ViewDTO get(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id, @Context SearchUser searchUser) {
        if ("default".equals(id)) {
            return this.dbService.getDefault().filter(searchUser::canReadView).orElseThrow(() -> new NotFoundException("Default view doesn't exist"));
        }
        ViewDTO view = this.resolveView(id);
        if (searchUser.canReadView(view)) {
            return view;
        }
        throw this.viewNotFoundException(id);
    }

    private ViewDTO resolveView(String id) {
        ViewResolverDecoder decoder = new ViewResolverDecoder(id);
        if (decoder.isResolverViewId()) {
            ViewResolver viewResolver = this.viewResolvers.get(decoder.getResolverName());
            if (viewResolver != null) {
                return viewResolver.get(decoder.getViewId()).orElseThrow(() -> new NotFoundException("Failed to resolve view:" + id));
            }
            throw new NotFoundException("Failed to find view resolver: " + decoder.getResolverName());
        }
        return this.loadView(id);
    }

    @POST
    @ApiOperation(value="Create a new view")
    @AuditEvent(type="views:view:create")
    public ViewDTO create(@ApiParam @Valid @NotNull(message="View is mandatory") @Valid @NotNull(message="View is mandatory") ViewDTO dto, @Context UserContext userContext, @Context SearchUser searchUser) throws ValidationException {
        if (dto.type().equals((Object)ViewDTO.Type.DASHBOARD) && !searchUser.canCreateDashboards()) {
            throw new ForbiddenException("User is not allowed to create new dashboards.");
        }
        this.validateIntegrity(dto, searchUser);
        User user = userContext.getUser();
        return this.dbService.saveWithOwner(dto.toBuilder().owner(searchUser.username()).build(), user);
    }

    private void validateIntegrity(ViewDTO dto, SearchUser searchUser) {
        Search search = this.searchDomain.getForUser(dto.searchId(), searchUser).orElseThrow(() -> new BadRequestException("Search " + dto.searchId() + " not available"));
        this.validateSearchProperties(dto, search);
    }

    protected void validateSearchProperties(ViewDTO dto, Search search) {
        Set stateTypes;
        Set<String> stateQueries;
        Set searchQueries = search.queries().stream().map(Query::id).collect(Collectors.toSet());
        if (!searchQueries.containsAll(stateQueries = dto.state().keySet())) {
            Sets.SetView diff = Sets.difference(stateQueries, searchQueries);
            String message = String.format(Locale.ROOT, "Search queries do not correspond to view/state queries, missing query IDs: %s; search queries: %s; state queries: %s", diff, searchQueries, stateQueries);
            throw new BadRequestException(message);
        }
        Set searchTypes = search.queries().stream().flatMap(q -> q.searchTypes().stream()).map(SearchType::id).collect(Collectors.toSet());
        if (!searchTypes.containsAll(stateTypes = dto.state().values().stream().flatMap(v -> v.widgetMapping().values().stream()).flatMap(Collection::stream).collect(Collectors.toSet()))) {
            Sets.SetView diff = Sets.difference(stateTypes, searchTypes);
            String message = String.format(Locale.ROOT, "Search types do not correspond to view/search types, missing searches %s; search types: %s; state types: %s", diff, searchTypes, stateTypes);
            throw new BadRequestException(message);
        }
        Set widgetIds = dto.state().values().stream().flatMap(v -> v.widgets().stream()).map(WidgetDTO::id).collect(Collectors.toSet());
        Set widgetPositions = dto.state().values().stream().flatMap(v -> v.widgetPositions().keySet().stream()).collect(Collectors.toSet());
        if (!widgetPositions.containsAll(widgetIds)) {
            Sets.SetView diff = Sets.difference(widgetIds, widgetPositions);
            String message = String.format(Locale.ROOT, "Widget positions don't correspond to widgets, missing widget positions %s; widget IDs: %s; widget positions: %s", diff, widgetIds, widgetPositions);
            throw new BadRequestException(message);
        }
    }

    @PUT
    @Path(value="{id}")
    @ApiOperation(value="Update view")
    @AuditEvent(type="views:view:update")
    public ViewDTO update(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id, @ApiParam @Valid ViewDTO dto, @Context SearchUser searchUser) {
        ViewDTO updatedDTO = dto.toBuilder().id(id).build();
        if (!searchUser.canUpdateView(updatedDTO)) {
            throw new ForbiddenException("Not allowed to edit " + this.summarize(updatedDTO) + ".");
        }
        this.validateIntegrity(updatedDTO, searchUser);
        return this.dbService.update(updatedDTO);
    }

    @PUT
    @Path(value="{id}/default")
    @ApiOperation(value="Configures the view as default view")
    @AuditEvent(type="views:default_view:set")
    public void setDefault(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        this.checkPermission("view:read", id);
        this.checkPermission("default-view:set");
        this.dbService.saveDefault(this.loadView(id));
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete view")
    @AuditEvent(type="views:view:delete")
    public ViewDTO delete(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id, @Context SearchUser searchUser) {
        ViewDTO view = this.loadView(id);
        if (!searchUser.canDeleteView(view)) {
            throw new ForbiddenException("Unable to delete " + this.summarize(view) + ".");
        }
        this.dbService.delete(id);
        this.triggerDeletedEvent(view);
        return view;
    }

    private String summarize(ViewDTO view) {
        return view.type().toString().toLowerCase(Locale.ROOT) + " <" + view.id() + ">";
    }

    private void triggerDeletedEvent(ViewDTO dto) {
        if (dto != null && dto.type() != null && dto.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            DashboardDeletedEvent dashboardDeletedEvent = DashboardDeletedEvent.create(dto.id());
            this.clusterEventBus.post(dashboardDeletedEvent);
        }
    }

    private ViewDTO loadView(String id) {
        try {
            return this.dbService.get(id).orElseThrow(() -> this.viewNotFoundException(id));
        }
        catch (IllegalArgumentException ignored) {
            throw this.viewNotFoundException(id);
        }
    }

    private NotFoundException viewNotFoundException(String id) {
        return new NotFoundException("View " + id + " doesn't exist");
    }
}

