/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.Renderer;
import com.google.common.html.HtmlEscapers;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class HtmlSafeJmteEngineProvider
implements Provider<Engine> {
    private final Engine engine = Engine.createEngine();

    @Inject
    public HtmlSafeJmteEngineProvider() {
        this.engine.registerRenderer(String.class, (Renderer)new HtmlSafeRenderer());
    }

    public Engine get() {
        return this.engine;
    }

    private static class HtmlSafeRenderer
    implements Renderer<String> {
        private HtmlSafeRenderer() {
        }

        public String render(String value, Locale locale, Map<String, Object> model) {
            return HtmlEscapers.htmlEscaper().escape(value);
        }
    }
}

