/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.log4j2.InstrumentedAppender;
import com.github.joschi.jadconfig.ConverterFactory;
import com.github.joschi.jadconfig.JadConfig;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.guava.GuavaConverterFactory;
import com.github.joschi.jadconfig.guice.NamedConfigParametersModule;
import com.github.joschi.jadconfig.jodatime.JodaTimeConverterFactory;
import com.github.joschi.jadconfig.repositories.EnvironmentRepository;
import com.github.joschi.jadconfig.repositories.PropertiesRepository;
import com.github.joschi.jadconfig.repositories.SystemPropertiesRepository;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.CliCommand;
import org.graylog2.bootstrap.Main;
import org.graylog2.configuration.PathConfiguration;
import org.graylog2.configuration.TLSProtocolsConfiguration;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.featureflag.FeatureFlagsFactory;
import org.graylog2.plugin.DocsHelper;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginLoaderConfig;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.system.NodeIdPersistenceException;
import org.graylog2.shared.UI;
import org.graylog2.shared.bindings.GuiceInjectorHolder;
import org.graylog2.shared.bindings.PluginBindings;
import org.graylog2.shared.metrics.MetricRegistryFactory;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.plugins.PluginLoader;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.UnsupportedSearchException;
import org.graylog2.storage.versionprobe.ElasticsearchProbeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmdLineTool
implements CliCommand {
    public static final String GRAYLOG_ENVIRONMENT_VAR_PREFIX = "GRAYLOG_";
    public static final String GRAYLOG_SYSTEM_PROP_PREFIX = "graylog.";
    private static final Logger LOG;
    protected static final Version version;
    protected static final String FILE_SEPARATOR;
    protected static final String TMPDIR;
    protected final JadConfig jadConfig = new JadConfig();
    protected final Configuration configuration;
    protected final ChainingClassLoader chainingClassLoader;
    @Option(name={"--dump-config"}, description="Show the effective Graylog configuration and exit")
    protected boolean dumpConfig = false;
    @Option(name={"--dump-default-config"}, description="Show the default configuration and exit")
    protected boolean dumpDefaultConfig = false;
    @Option(name={"-d", "--debug"}, description="Run Graylog in debug mode")
    private boolean debug = false;
    @Option(name={"-f", "--configfile"}, description="Configuration file for Graylog")
    private String configFile = "/etc/graylog/server/server.conf";
    @Option(name={"-ff", "--featureflagfile"}, description="Configuration file for Graylog feature flags")
    private String customFeatureFlagFile = "/etc/graylog/server/feature-flag.conf";
    protected String commandName = "command";
    protected Injector injector;
    protected Injector coreConfigInjector;
    protected FeatureFlags featureFlags;

    protected CmdLineTool(Configuration configuration) {
        this(null, configuration);
    }

    protected CmdLineTool(String commandName, Configuration configuration) {
        this.jadConfig.addConverterFactory((ConverterFactory)new GuavaConverterFactory());
        this.jadConfig.addConverterFactory((ConverterFactory)new JodaTimeConverterFactory());
        this.commandName = commandName == null ? (this.getClass().isAnnotationPresent(Command.class) ? this.getClass().getAnnotation(Command.class).name() : "tool") : commandName;
        this.configuration = configuration;
        this.chainingClassLoader = new ChainingClassLoader(this.getClass().getClassLoader());
    }

    protected boolean validateConfiguration() {
        return true;
    }

    public boolean isDumpConfig() {
        return this.dumpConfig;
    }

    public boolean isDumpDefaultConfig() {
        return this.dumpDefaultConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected abstract List<Module> getCommandBindings();

    protected abstract List<Object> getCommandConfigurationBeans();

    public boolean isMigrationCommand() {
        return this.commandName.equals("migrate");
    }

    protected void beforeStart() {
    }

    protected void beforeStart(TLSProtocolsConfiguration configuration, PathConfiguration pathConfiguration) {
    }

    protected void beforeInjectorCreation(Set<Plugin> plugins) {
    }

    protected static void applySecuritySettings(TLSProtocolsConfiguration configuration) {
        CmdLineTool.setSystemPropertyIfEmpty("jdk.tls.ephemeralDHKeySize", "2048");
        CmdLineTool.setSystemPropertyIfEmpty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
        ImmutableSet tlsProtocols = configuration.getConfiguredTlsProtocols();
        List disabledAlgorithms = Stream.of(Security.getProperty("jdk.tls.disabledAlgorithms").split(",")).map(String::trim).collect(Collectors.toList());
        if (tlsProtocols == null || !tlsProtocols.isEmpty() && !tlsProtocols.contains("TLSv1") && !tlsProtocols.contains("TLSv1.1")) {
            disabledAlgorithms.addAll(ImmutableSet.of((Object)"CBC", (Object)"3DES"));
            Security.setProperty("jdk.tls.disabledAlgorithms", joptsimple.internal.Strings.join(disabledAlgorithms, (String)", "));
        } else {
            ImmutableSet reEnabledTLSProtocols = tlsProtocols.isEmpty() ? ImmutableSet.of((Object)"TLSv1", (Object)"TLSv1.1") : tlsProtocols;
            List updatedProperties = disabledAlgorithms.stream().filter(arg_0 -> CmdLineTool.lambda$applySecuritySettings$0((Set)reEnabledTLSProtocols, arg_0)).collect(Collectors.toList());
            Security.setProperty("jdk.tls.disabledAlgorithms", joptsimple.internal.Strings.join(updatedProperties, (String)", "));
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static void setSystemPropertyIfEmpty(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    @Override
    public void run() {
        Level logLevel = this.setupLogger();
        MetricRegistry metricRegistry = MetricRegistryFactory.create();
        this.featureFlags = this.getFeatureFlags(metricRegistry);
        if (this.isDumpDefaultConfig()) {
            this.dumpDefaultConfigAndExit();
        }
        this.installConfigRepositories();
        this.installCommandConfig();
        this.beforeStart();
        this.beforeStart(this.parseAndGetTLSConfiguration(), this.parseAndGetPathConfiguration(this.configFile));
        this.processConfiguration(this.jadConfig);
        this.coreConfigInjector = this.setupCoreConfigInjector();
        Set<Plugin> plugins = this.loadPlugins(this.getPluginPath(this.configFile), this.chainingClassLoader);
        this.installPluginConfig(plugins);
        this.processConfiguration(this.jadConfig);
        if (this.isDumpConfig()) {
            this.dumpCurrentConfigAndExit();
        }
        if (!this.validateConfiguration()) {
            LOG.error("Validating configuration file failed - exiting.");
            System.exit(1);
        }
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        LOG.info("Running with JVM arguments: {}", (Object)Joiner.on((char)' ').join(arguments));
        this.beforeInjectorCreation(plugins);
        this.injector = this.setupInjector(new Module[]{new NamedConfigParametersModule((Collection)this.jadConfig.getConfigurationBeans()), new PluginBindings(plugins), binder -> binder.bind(MetricRegistry.class).toInstance((Object)metricRegistry)});
        if (this.injector == null) {
            LOG.error("Injector could not be created, exiting! (Please include the previous error messages in bug reports.)");
            System.exit(1);
        }
        this.addInstrumentedAppender(metricRegistry, logLevel);
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
        reporter.start();
        this.startCommand();
    }

    private TLSProtocolsConfiguration parseAndGetTLSConfiguration() {
        JadConfig jadConfig = new JadConfig();
        jadConfig.setRepositories(this.getConfigRepositories(this.configFile));
        TLSProtocolsConfiguration tlsConfiguration = new TLSProtocolsConfiguration();
        jadConfig.addConfigurationBean((Object)tlsConfiguration);
        this.processConfiguration(jadConfig);
        return tlsConfiguration;
    }

    private PathConfiguration parseAndGetPathConfiguration(String configFile) {
        PathConfiguration pathConfiguration = new PathConfiguration();
        this.processConfiguration(new JadConfig(this.getConfigRepositories(configFile), new Object[]{pathConfiguration}));
        return pathConfiguration;
    }

    private void installCommandConfig() {
        this.getCommandConfigurationBeans().forEach(arg_0 -> ((JadConfig)this.jadConfig).addConfigurationBean(arg_0));
    }

    private void installPluginConfig(Set<Plugin> plugins) {
        plugins.stream().flatMap(plugin -> plugin.modules().stream()).flatMap(pm -> pm.getConfigBeans().stream()).forEach(arg_0 -> ((JadConfig)this.jadConfig).addConfigurationBean(arg_0));
    }

    protected abstract void startCommand();

    protected Level setupLogger() {
        Level logLevel;
        if (this.isDebug()) {
            LOG.info("Running in Debug mode");
            logLevel = Level.DEBUG;
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        } else {
            logLevel = this.onlyLogErrors() ? Level.ERROR : Level.INFO;
        }
        this.initializeLogging(logLevel);
        return logLevel;
    }

    private void initializeLogging(Level logLevel) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        org.apache.logging.log4j.core.config.Configuration config = context.getConfiguration();
        config.getLoggerConfig("").setLevel(logLevel);
        config.getLoggerConfig(Main.class.getPackage().getName()).setLevel(logLevel);
        context.updateLoggers(config);
    }

    private void addInstrumentedAppender(MetricRegistry metrics, Level level) {
        InstrumentedAppender appender = new InstrumentedAppender(metrics, null, null, false);
        appender.start();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        org.apache.logging.log4j.core.config.Configuration config = context.getConfiguration();
        config.getLoggerConfig("").addAppender((Appender)appender, level, null);
        context.updateLoggers(config);
    }

    protected boolean onlyLogErrors() {
        return false;
    }

    private void dumpCurrentConfigAndExit() {
        System.out.println(this.dumpConfiguration(this.jadConfig.dump()));
        System.exit(0);
    }

    private void dumpDefaultConfigAndExit() {
        this.installCommandConfig();
        this.coreConfigInjector = this.setupCoreConfigInjector();
        this.installPluginConfig(this.loadPlugins(this.getPluginPath(this.configFile), this.chainingClassLoader));
        this.dumpCurrentConfigAndExit();
    }

    private Path getPluginPath(String configFile) {
        PluginLoaderConfig pluginLoaderConfig = new PluginLoaderConfig();
        this.processConfiguration(new JadConfig(this.getConfigRepositories(configFile), new Object[]{pluginLoaderConfig}));
        return pluginLoaderConfig.getPluginDir();
    }

    private FeatureFlags getFeatureFlags(MetricRegistry metricRegistry) {
        return new FeatureFlagsFactory().createImmutableFeatureFlags(this.customFeatureFlagFile, metricRegistry);
    }

    protected Set<Plugin> loadPlugins(Path pluginPath, ChainingClassLoader chainingClassLoader) {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        PluginLoader pluginLoader = new PluginLoader(pluginPath.toFile(), chainingClassLoader, this.coreConfigInjector);
        for (Plugin plugin : pluginLoader.loadPlugins()) {
            PluginMetaData metadata = plugin.metadata();
            if (this.capabilities().containsAll(metadata.getRequiredCapabilities())) {
                if (version.sameOrHigher(metadata.getRequiredVersion())) {
                    LOG.info("Loaded plugin: {}", (Object)plugin);
                    plugins.add(plugin);
                    continue;
                }
                LOG.error("Plugin \"" + metadata.getName() + "\" requires version " + metadata.getRequiredVersion() + " - not loading!");
                continue;
            }
            LOG.debug("Skipping plugin \"{}\" because some capabilities are missing ({}).", (Object)metadata.getName(), (Object)Sets.difference(plugin.metadata().getRequiredCapabilities(), this.capabilities()));
        }
        return plugins;
    }

    protected Collection<Repository> getConfigRepositories(String configFile) {
        return Arrays.asList(new EnvironmentRepository(GRAYLOG_ENVIRONMENT_VAR_PREFIX), new SystemPropertiesRepository(GRAYLOG_SYSTEM_PROP_PREFIX), new EnvironmentRepository("GRAYLOG2_"), new SystemPropertiesRepository("graylog2."), new PropertiesRepository(configFile));
    }

    private String dumpConfiguration(Map<String, String> configMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Configuration of graylog2-").append(this.commandName).append(" ").append(version).append(System.lineSeparator());
        sb.append("# Generated on ").append(Tools.nowUTC()).append(System.lineSeparator());
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            sb.append(entry.getKey()).append('=').append(Strings.nullToEmpty((String)entry.getValue())).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private void installConfigRepositories() {
        this.jadConfig.setRepositories(this.getConfigRepositories(this.configFile));
    }

    protected void processConfiguration(JadConfig jadConfig) {
        try {
            jadConfig.process();
        }
        catch (RepositoryException e) {
            LOG.error("Couldn't load configuration: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (ParameterException | ValidationException e) {
            LOG.error("Invalid configuration", e);
            System.exit(1);
        }
    }

    protected List<Module> getSharedBindingsModules() {
        return Lists.newArrayList();
    }

    protected Injector setupInjector(Module ... modules) {
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.getSharedBindingsModules());
            builder.addAll(this.getCommandBindings());
            builder.addAll(Arrays.asList(modules));
            builder.add(binder -> {
                binder.bind(ChainingClassLoader.class).toInstance((Object)this.chainingClassLoader);
                this.featureFlagsBinding(binder);
                binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"BootstrapCommand")).toInstance((Object)this.commandName);
            });
            return GuiceInjectorHolder.createInjector((List<Module>)builder.build());
        }
        catch (CreationException e) {
            this.annotateInjectorCreationException(e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Injector creation failed!", (Throwable)e);
            return null;
        }
    }

    protected Injector setupCoreConfigInjector() {
        NamedConfigParametersModule configModule = new NamedConfigParametersModule((Collection)this.jadConfig.getConfigurationBeans());
        Injector coreConfigInjector = null;
        try {
            coreConfigInjector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)ImmutableList.of((Object)configModule, Binder::requireExplicitBindings, this::featureFlagsBinding));
        }
        catch (CreationException e) {
            this.annotateInjectorCreationException(e);
        }
        catch (Exception e) {
            LOG.error("Injector creation failed!", (Throwable)e);
        }
        if (coreConfigInjector == null) {
            LOG.error("Injector for core configuration could not be created, exiting! (Please include the previous error messages in bug reports.)");
            System.exit(1);
        }
        return coreConfigInjector;
    }

    private void featureFlagsBinding(Binder binder) {
        binder.bind(FeatureFlags.class).toInstance((Object)this.featureFlags);
    }

    protected void annotateInjectorCreationException(CreationException e) {
        this.annotateInjectorExceptions(e.getErrorMessages());
        throw e;
    }

    protected void annotateInjectorExceptions(Collection<Message> messages) {
        for (Message message : messages) {
            Throwable rootCause = ExceptionUtils.getRootCause(message.getCause());
            if (rootCause instanceof NodeIdPersistenceException) {
                LOG.error(UI.wallString("Unable to read or persist your NodeId file. This means your node id file (" + this.configuration.getNodeIdFile() + ") is not readable or writable by the current user. The following exception might give more information: " + message, new String[0]));
                System.exit(-1);
                continue;
            }
            if (rootCause instanceof AccessDeniedException) {
                LOG.error(UI.wallString("Unable to access file " + rootCause.getMessage(), new String[0]));
                System.exit(-2);
                continue;
            }
            if (rootCause instanceof UnsupportedSearchException) {
                SearchVersion search = ((UnsupportedSearchException)rootCause).getSearchMajorVersion();
                LOG.error(UI.wallString("Unsupported search version: " + search, DocsHelper.PAGE_ES_VERSIONS.toString()));
                System.exit(-3);
                continue;
            }
            if (rootCause instanceof ElasticsearchProbeException) {
                LOG.error(UI.wallString(rootCause.getMessage(), DocsHelper.PAGE_ES_CONFIGURATION.toString()));
                System.exit(-4);
                continue;
            }
            LOG.error("Guice error (more detail on log level debug): {}", (Object)message.getMessage());
            if (rootCause == null) continue;
            LOG.debug("Stacktrace:", rootCause);
        }
    }

    protected Set<ServerStatus.Capability> capabilities() {
        return Collections.emptySet();
    }

    private static /* synthetic */ boolean lambda$applySecuritySettings$0(Set reEnabledTLSProtocols, String p) {
        return !reEnabledTLSProtocols.contains(p);
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        LOG = LoggerFactory.getLogger(CmdLineTool.class);
        version = Version.CURRENT_CLASSPATH;
        FILE_SEPARATOR = System.getProperty("file.separator");
        TMPDIR = System.getProperty("java.io.tmpdir", "/tmp");
    }
}

