/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.leader;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.cluster.leader.LeaderChangedEvent;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.cluster.lock.LockService;
import org.graylog2.periodical.NodePingThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AutomaticLeaderElectionService
extends AbstractExecutionThreadService
implements LeaderElectionService {
    private static final String RESOURCE_NAME = "cluster-leader";
    private static final Logger log = LoggerFactory.getLogger(AutomaticLeaderElectionService.class);
    public static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(2L);
    private final LockService lockService;
    private final EventBus eventBus;
    private final NodePingThread nodePingThread;
    private final Duration pollingInterval;
    private final Duration lockTTL;
    private volatile boolean isLeader = false;
    private Thread executionThread;

    @Inject
    public AutomaticLeaderElectionService(Configuration configuration, LockService lockService, EventBus eventBus, NodePingThread nodePingThread) {
        this.pollingInterval = configuration.getLeaderElectionLockPollingInterval();
        this.lockTTL = configuration.getLockServiceLockTTL();
        this.lockService = lockService;
        this.eventBus = eventBus;
        this.nodePingThread = nodePingThread;
    }

    protected void startUp() throws Exception {
        super.startUp();
        this.executionThread = Thread.currentThread();
    }

    protected void triggerShutdown() {
        this.executionThread.interrupt();
    }

    protected void shutDown() {
        this.isLeader = false;
        this.lockService.unlock(RESOURCE_NAME).ifPresent(l -> log.info("Gave up leader lock on shutdown"));
    }

    @Override
    public boolean isLeader() {
        return this.isLeader;
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            try {
                this.runIteration();
            }
            catch (Throwable t) {
                log.error("Exception while acquiring/renewing leader lock.", t);
            }
        }
    }

    private void runIteration() {
        boolean wasLeader;
        block3: {
            wasLeader = this.isLeader;
            try {
                this.isLeader = this.lockService.lock(RESOURCE_NAME).isPresent();
            }
            catch (Exception e) {
                log.error("Unable to acquire/renew leader lock.", (Throwable)e);
                if (!wasLeader) break block3;
                log.error("Failed to renew leader lock. Forcing fallback to follower role.");
                this.isLeader = false;
            }
        }
        if (wasLeader != this.isLeader) {
            this.handleLeaderChange(this.isLeader);
        }
        this.pauseBeforeNextIteration(wasLeader && !this.isLeader);
    }

    private void pauseBeforeNextIteration(boolean isDowngrade) {
        try {
            if (isDowngrade) {
                log.info("Pausing leader-lock acquisition attempts for {} after downgrade from leader.", (Object)this.lockTTL);
                Thread.sleep(this.lockTTL.toMillis());
                log.info("Resuming leader-lock acquisition attempts every {}.", (Object)this.pollingInterval);
            } else {
                Thread.sleep(this.pollingInterval.toMillis());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleLeaderChange(boolean isLeader) {
        if (isLeader) {
            log.info("Leader changed. This node is now the leader.");
        } else {
            log.error("Leader changed. This node lost the leader role. This should not happen. The node will attempt to gracefully transition to assuming a follower role.");
        }
        try {
            this.nodePingThread.doRun();
        }
        catch (Exception e) {
            log.error("Unable to trigger update of nodes collection.");
        }
        this.eventBus.post((Object)new LeaderChangedEvent());
    }
}

