/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackV1;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.Revisioned;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.database.MongoConnection;
import org.graylog2.streams.StreamService;
import org.jooq.lambda.tuple.Tuple2;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContentPackPersistenceService {
    public static final String COLLECTION_NAME = "content_packs";
    private final JacksonDBCollection<ContentPack, ObjectId> dbCollection;
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackPersistenceService.class);
    private final StreamService streamService;

    @Inject
    public ContentPackPersistenceService(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, StreamService streamService) {
        this((JacksonDBCollection<ContentPack, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ContentPack.class, ObjectId.class, (ObjectMapper)mapperProvider.get()), streamService);
    }

    ContentPackPersistenceService(JacksonDBCollection<ContentPack, ObjectId> dbCollection, StreamService streamService) {
        this.dbCollection = dbCollection;
        this.streamService = streamService;
        try {
            dbCollection.createIndex((DBObject)new BasicDBObject("id", (Object)1).append("rev", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    public Set<ContentPack> loadAll() {
        DBCursor contentPacks = this.dbCollection.find();
        return ImmutableSet.copyOf((Iterable)contentPacks);
    }

    public Set<ContentPack> loadAllLatest() {
        Set<ContentPack> allContentPacks = this.loadAll();
        ImmutableMultimap.Builder byIdBuilder = ImmutableMultimap.builder();
        for (ContentPack contentPack : allContentPacks) {
            byIdBuilder.put((Object)contentPack.id(), (Object)contentPack);
        }
        ImmutableMultimap contentPacksById = byIdBuilder.build();
        ImmutableSet.Builder latestContentPacks = ImmutableSet.builderWithExpectedSize((int)contentPacksById.keySet().size());
        for (ModelId id : contentPacksById.keySet()) {
            ImmutableCollection contentPacks = contentPacksById.get((Object)id);
            ContentPack latestContentPackRevision = Collections.max(contentPacks, Comparator.comparingInt(Revisioned::revision));
            latestContentPacks.add((Object)latestContentPackRevision);
        }
        return latestContentPacks.build();
    }

    public Set<ContentPack> findAllById(ModelId id) {
        DBCursor result = this.dbCollection.find(DBQuery.is((String)"id", (Object)id));
        return ImmutableSet.copyOf((Iterable)result);
    }

    public Optional<ContentPack> findByIdAndRevision(ModelId id, int revision) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"id", (Object)id).is("rev", (Object)revision);
        return Optional.ofNullable((ContentPack)this.dbCollection.findOne(query));
    }

    public Optional<ContentPack> insert(ContentPack pack) {
        if (this.findByIdAndRevision(pack.id(), pack.revision()).isPresent()) {
            LOG.debug("Content pack already found: id: {} revision: {}. Did not insert!", (Object)pack.id(), (Object)pack.revision());
            return Optional.empty();
        }
        WriteResult writeResult = this.dbCollection.insert((Object)pack);
        return Optional.of((ContentPack)writeResult.getSavedObject());
    }

    public Optional<ContentPack> filterMissingResourcesAndInsert(ContentPack pack) {
        ContentPackV1 cpv1 = (ContentPackV1)pack;
        Set allStreams = this.streamService.loadAll().stream().map(stream -> stream.getTitle()).collect(Collectors.toSet());
        HashMap streamsInContentPack = new HashMap();
        cpv1.entities().stream().filter(entity -> "stream".equals(entity.type().name()) && "1".equals(entity.type().version())).map(entity -> new Tuple2((Object)entity.id().id(), (Object)((EntityV1)entity).data().findValue("title"))).forEach(tuple2 -> {
            JsonNode title = ((JsonNode)tuple2.v2()).findValue("@value");
            streamsInContentPack.put((String)tuple2.v1(), title.textValue());
        });
        cpv1.entities().stream().filter(entity -> "dashboard".equals(entity.type().name()) && "2".equals(entity.type().version())).map(entity -> ((EntityV1)entity).data().findValue("search")).map(node -> node.findValue("queries")).map(node -> node.findValue("search_types")).forEach(node -> {
            ObjectNode parent = (ObjectNode)node.findParent("streams");
            ArrayNode streams = (ArrayNode)node.findValue("streams");
            if (streams != null) {
                ArrayNode filtered = streams.deepCopy();
                filtered.removeAll();
                streams.forEach(stream -> {
                    String sid = stream.textValue();
                    String stitle = (String)streamsInContentPack.get(sid);
                    if (allStreams.contains(stitle)) {
                        filtered.add(stream);
                    }
                });
                parent.replace("streams", (JsonNode)filtered);
            }
        });
        return this.insert(cpv1);
    }

    public int deleteById(ModelId id) {
        DBQuery.Query query = DBQuery.is((String)"id", (Object)id);
        WriteResult writeResult = this.dbCollection.remove(query);
        return writeResult.getN();
    }

    public int deleteByIdAndRevision(ModelId id, int revision) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"id", (Object)id).is("rev", (Object)revision);
        WriteResult writeResult = this.dbCollection.remove(query);
        return writeResult.getN();
    }
}

