/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

@JsonAutoDetect
public class ValidationResult {
    private final Multimap<String, String> errors = ArrayListMultimap.create();
    private final Multimap<String, String> context = ArrayListMultimap.create();

    public ValidationResult addError(String fieldName, String error) {
        this.errors.put((Object)fieldName, (Object)error);
        return this;
    }

    public ValidationResult addContext(String fieldName, Iterable<String> values) {
        this.context.putAll((Object)fieldName, values);
        return this;
    }

    public ValidationResult addAll(Multimap<String, String> extraErrors) {
        this.errors.putAll(extraErrors);
        return this;
    }

    public ValidationResult addAll(ValidationResult validationResult) {
        this.errors.putAll(validationResult.errors);
        this.context.putAll(validationResult.context);
        return this;
    }

    @JsonProperty(value="failed")
    public boolean failed() {
        return !this.errors.isEmpty();
    }

    @JsonProperty(value="errors")
    public Map<String, Collection<String>> getErrors() {
        return this.errors.asMap();
    }

    @JsonProperty(value="error_context")
    public Map<String, Collection<String>> getContext() {
        return this.context.asMap();
    }
}

