/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.processing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.system.processing.ProcessingStatusRecorder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

@Singleton
public class InMemoryProcessingStatusRecorder
implements ProcessingStatusRecorder {
    private final AtomicReference<DateTime> ingestReceiveTime = new AtomicReference<DateTime>(new DateTime(0L, DateTimeZone.UTC));
    private final AtomicReference<DateTime> postProcessingReceiveTime = new AtomicReference<DateTime>(new DateTime(0L, DateTimeZone.UTC));
    private final AtomicReference<DateTime> postIndexReceiveTime = new AtomicReference<DateTime>(new DateTime(0L, DateTimeZone.UTC));
    @VisibleForTesting
    final AtomicLong uncommittedMessages = new AtomicLong(0L);
    @VisibleForTesting
    final AtomicDouble readMessages1m = new AtomicDouble(0.0);
    @VisibleForTesting
    final AtomicDouble writtenMessages1m = new AtomicDouble(0.0);

    @Override
    public Lifecycle getNodeLifecycleStatus() {
        return Lifecycle.RUNNING;
    }

    @Override
    public DateTime getIngestReceiveTime() {
        return this.ingestReceiveTime.get();
    }

    @Override
    public DateTime getPostProcessingReceiveTime() {
        return this.postProcessingReceiveTime.get();
    }

    @Override
    public DateTime getPostIndexingReceiveTime() {
        return this.postIndexReceiveTime.get();
    }

    @Override
    public long getJournalInfoUncommittedEntries() {
        return this.uncommittedMessages.get();
    }

    @Override
    public double getJournalInfoReadMessages1mRate() {
        return this.readMessages1m.get();
    }

    @Override
    public double getJournalInfoWrittenMessages1mRate() {
        return this.writtenMessages1m.get();
    }

    @Override
    public void updateIngestReceiveTime(DateTime newTimestamp) {
        if (newTimestamp != null) {
            this.ingestReceiveTime.updateAndGet(timestamp -> this.latestTimestamp((DateTime)timestamp, newTimestamp));
        }
    }

    @Override
    public void updatePostProcessingReceiveTime(DateTime newTimestamp) {
        if (newTimestamp != null) {
            this.postProcessingReceiveTime.updateAndGet(timestamp -> this.latestTimestamp((DateTime)timestamp, newTimestamp));
        }
    }

    @Override
    public void updatePostIndexingReceiveTime(DateTime newTimestamp) {
        if (newTimestamp != null) {
            this.postIndexReceiveTime.updateAndGet(timestamp -> this.latestTimestamp((DateTime)timestamp, newTimestamp));
        }
    }

    private DateTime latestTimestamp(DateTime timestamp, DateTime newTimestamp) {
        return newTimestamp.isAfter((ReadableInstant)timestamp) ? newTimestamp : timestamp;
    }
}

