/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.graylog.plugins.map.config.DatabaseVendorType;
import org.graylog.plugins.map.config.GeoIpResolverConfig;

final class AutoValue_GeoIpResolverConfig
extends GeoIpResolverConfig {
    private final boolean enabled;
    private final boolean enforceGraylogSchema;
    private final DatabaseVendorType databaseVendorType;
    private final String cityDbPath;
    private final String asnDbPath;

    private AutoValue_GeoIpResolverConfig(boolean enabled, boolean enforceGraylogSchema, DatabaseVendorType databaseVendorType, String cityDbPath, String asnDbPath) {
        this.enabled = enabled;
        this.enforceGraylogSchema = enforceGraylogSchema;
        this.databaseVendorType = databaseVendorType;
        this.cityDbPath = cityDbPath;
        this.asnDbPath = asnDbPath;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="enforce_graylog_schema")
    public boolean enforceGraylogSchema() {
        return this.enforceGraylogSchema;
    }

    @Override
    @JsonProperty(value="db_vendor_type")
    public DatabaseVendorType databaseVendorType() {
        return this.databaseVendorType;
    }

    @Override
    @JsonProperty(value="city_db_path")
    public String cityDbPath() {
        return this.cityDbPath;
    }

    @Override
    @JsonProperty(value="asn_db_path")
    public String asnDbPath() {
        return this.asnDbPath;
    }

    public String toString() {
        return "GeoIpResolverConfig{enabled=" + this.enabled + ", enforceGraylogSchema=" + this.enforceGraylogSchema + ", databaseVendorType=" + (Object)((Object)this.databaseVendorType) + ", cityDbPath=" + this.cityDbPath + ", asnDbPath=" + this.asnDbPath + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GeoIpResolverConfig) {
            GeoIpResolverConfig that = (GeoIpResolverConfig)o;
            return this.enabled == that.enabled() && this.enforceGraylogSchema == that.enforceGraylogSchema() && this.databaseVendorType.equals((Object)that.databaseVendorType()) && this.cityDbPath.equals(that.cityDbPath()) && this.asnDbPath.equals(that.asnDbPath());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.enabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.enforceGraylogSchema ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.databaseVendorType.hashCode();
        h$ *= 1000003;
        h$ ^= this.cityDbPath.hashCode();
        h$ *= 1000003;
        return h$ ^= this.asnDbPath.hashCode();
    }

    @Override
    public GeoIpResolverConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GeoIpResolverConfig.Builder {
        private Boolean enabled;
        private Boolean enforceGraylogSchema;
        private DatabaseVendorType databaseVendorType;
        private String cityDbPath;
        private String asnDbPath;

        Builder() {
        }

        private Builder(GeoIpResolverConfig source) {
            this.enabled = source.enabled();
            this.enforceGraylogSchema = source.enforceGraylogSchema();
            this.databaseVendorType = source.databaseVendorType();
            this.cityDbPath = source.cityDbPath();
            this.asnDbPath = source.asnDbPath();
        }

        @Override
        public GeoIpResolverConfig.Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public GeoIpResolverConfig.Builder enforceGraylogSchema(boolean enforceGraylogSchema) {
            this.enforceGraylogSchema = enforceGraylogSchema;
            return this;
        }

        @Override
        public GeoIpResolverConfig.Builder databaseVendorType(DatabaseVendorType databaseVendorType) {
            if (databaseVendorType == null) {
                throw new NullPointerException("Null databaseVendorType");
            }
            this.databaseVendorType = databaseVendorType;
            return this;
        }

        @Override
        public GeoIpResolverConfig.Builder cityDbPath(String cityDbPath) {
            if (cityDbPath == null) {
                throw new NullPointerException("Null cityDbPath");
            }
            this.cityDbPath = cityDbPath;
            return this;
        }

        @Override
        public GeoIpResolverConfig.Builder asnDbPath(String asnDbPath) {
            if (asnDbPath == null) {
                throw new NullPointerException("Null asnDbPath");
            }
            this.asnDbPath = asnDbPath;
            return this;
        }

        @Override
        public GeoIpResolverConfig build() {
            String missing = "";
            if (this.enabled == null) {
                missing = missing + " enabled";
            }
            if (this.enforceGraylogSchema == null) {
                missing = missing + " enforceGraylogSchema";
            }
            if (this.databaseVendorType == null) {
                missing = missing + " databaseVendorType";
            }
            if (this.cityDbPath == null) {
                missing = missing + " cityDbPath";
            }
            if (this.asnDbPath == null) {
                missing = missing + " asnDbPath";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GeoIpResolverConfig(this.enabled, this.enforceGraylogSchema, this.databaseVendorType, this.cityDbPath, this.asnDbPath);
        }
    }
}

