/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.views.migrations.AutoValue_V20200730000000_AddGl2MessageIdFieldAliasForEvents_MigrationCompleted;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.storage.DetectedSearchVersion;
import org.graylog2.storage.SearchVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200730000000_AddGl2MessageIdFieldAliasForEvents
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200730000000_AddGl2MessageIdFieldAliasForEvents.class);
    private static final Version MINIMUM_ELASTICSEARCH_VERSION = Version.from(7, 0, 0);
    private final SearchVersion elasticsearchVersion;
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchAdapter elasticsearch;
    private final ElasticsearchConfiguration elasticsearchConfig;

    @Inject
    public V20200730000000_AddGl2MessageIdFieldAliasForEvents(@DetectedSearchVersion SearchVersion elasticsearchVersion, ClusterConfigService clusterConfigService, ElasticsearchAdapter elasticsearch, ElasticsearchConfiguration elasticsearchConfig) {
        this.elasticsearchVersion = elasticsearchVersion;
        this.clusterConfigService = clusterConfigService;
        this.elasticsearch = elasticsearch;
        this.elasticsearchConfig = elasticsearchConfig;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-07-30T00:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.shouldSkip()) {
            return;
        }
        ImmutableSet eventIndexPrefixes = ImmutableSet.of((Object)this.elasticsearchConfig.getDefaultEventsIndexPrefix(), (Object)this.elasticsearchConfig.getDefaultSystemEventsIndexPrefix());
        this.elasticsearch.addGl2MessageIdFieldAlias((Set<String>)eventIndexPrefixes);
        this.writeMigrationCompleted((ImmutableSet<String>)eventIndexPrefixes);
    }

    private boolean shouldSkip() {
        if (!new Version(this.elasticsearchVersion.version()).sameOrHigher(MINIMUM_ELASTICSEARCH_VERSION)) {
            LOG.debug("Skipping migration, because Elasticsearch major version of {} is lower than the required minimum version of {}.", (Object)this.elasticsearchVersion, (Object)MINIMUM_ELASTICSEARCH_VERSION);
            if (this.hasCompletedBefore()) {
                this.clusterConfigService.remove(MigrationCompleted.class);
            }
            return true;
        }
        if (this.hasCompletedBefore()) {
            LOG.debug("Migration already completed.");
            return true;
        }
        return false;
    }

    private boolean hasCompletedBefore() {
        return this.clusterConfigService.get(MigrationCompleted.class) != null;
    }

    private void writeMigrationCompleted(ImmutableSet<String> eventIndexPrefixes) {
        this.clusterConfigService.write(MigrationCompleted.create(eventIndexPrefixes));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="modified_index_prefixes")
        public abstract Set<String> modifiedIndexPrefixes();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="modified_index_prefixes") Set<String> modifiedIndexPrefixes) {
            return new AutoValue_V20200730000000_AddGl2MessageIdFieldAliasForEvents_MigrationCompleted(modifiedIndexPrefixes);
        }
    }

    public static interface ElasticsearchAdapter {
        public void addGl2MessageIdFieldAlias(Set<String> var1);
    }
}

