/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.function.Supplier;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.export.ExportJob;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog.plugins.views.search.export.MessagesRequestExportJob;
import org.graylog.plugins.views.search.export.ResultFormat;
import org.graylog.plugins.views.search.export.SearchExportJob;
import org.graylog.plugins.views.search.export.SearchTypeExportJob;

public class ExportJobFactory {
    private final Supplier<String> idGenerator = () -> new ObjectId().toHexString();

    public ExportJob fromMessagesRequest(MessagesRequest messagesRequest) {
        return MessagesRequestExportJob.fromMessagesRequest(this.idGenerator.get(), messagesRequest);
    }

    public ExportJob forSearch(String searchId, ResultFormat resultFormat) {
        return SearchExportJob.forSearch(this.idGenerator.get(), searchId, resultFormat);
    }

    public ExportJob forSearchType(String searchId, String searchTypeId, ResultFormat resultFormat) {
        return SearchTypeExportJob.forSearchType(this.idGenerator.get(), searchId, searchTypeId, resultFormat);
    }
}

