/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import java.util.function.Predicate;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.graylog2.streams.StreamDTO;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class PaginatedStreamService
extends PaginatedDbService<StreamDTO> {
    private static final String COLLECTION_NAME = "streams";

    @Inject
    public PaginatedStreamService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, StreamDTO.class, COLLECTION_NAME);
    }

    public long count() {
        return this.db.count();
    }

    public PaginatedList<StreamDTO> findPaginated(SearchQuery searchQuery, Predicate<StreamDTO> filter, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryFilterAndSort(dbQuery, filter, sortBuilder, page, perPage);
    }
}

