/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import org.apache.lucene.queryparser.classic.CharStream;

public class TokenLineCounter {
    private final CharStream delegate;
    private int positionPointer;
    private int tokenBeginsAtLine;
    private int tokenBeginsAtPosition;
    private int lineCounter = 1;
    private int currentLineStartsAtPosition;

    public TokenLineCounter(CharStream delegate) {
        this.delegate = delegate;
    }

    public void beginToken(char oneChar) {
        this.tokenBeginsAtLine = this.lineCounter;
        this.tokenBeginsAtPosition = this.delegate.getBeginColumn();
        this.processChar(oneChar);
    }

    public void processChar(char oneChar) {
        int currentCharPosition = this.delegate.getEndColumn();
        if (currentCharPosition > this.positionPointer) {
            this.positionPointer = this.delegate.getEndColumn();
            if (oneChar == '\n') {
                ++this.lineCounter;
                this.currentLineStartsAtPosition = this.positionPointer;
            }
        }
    }

    public int getBeginLine() {
        return this.tokenBeginsAtLine;
    }

    public int getBeginColumn() {
        return this.tokenBeginsAtPosition - this.currentLineStartsAtPosition;
    }

    public int getEndLine() {
        return this.lineCounter;
    }

    public int getEndColumn() {
        return this.delegate.getEndColumn() - this.currentLineStartsAtPosition;
    }

    public void incrementTokenStartPositionOnError() {
        ++this.tokenBeginsAtPosition;
        if (this.tokenBeginsAtLine != this.lineCounter) {
            this.tokenBeginsAtLine = this.lineCounter;
        }
    }
}

