/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.regex.Pattern;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;

public class SplitAndCountConverter
extends Converter {
    private final String splitByEscaped;

    public SplitAndCountConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.SPLIT_AND_COUNT, config);
        String splitBy = (String)config.get("split_by");
        if (Strings.isNullOrEmpty((String)splitBy)) {
            throw new ConfigurationException("Missing config [split_by].");
        }
        this.splitByEscaped = Pattern.quote(splitBy);
    }

    @Override
    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        return value.split(this.splitByEscaped).length;
    }

    @Override
    public boolean buildsMultipleFields() {
        return false;
    }
}

