/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.apache.logging.log4j.util.Strings;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog.events.notifications.types.EmailSender;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(EmailEventNotification.class);
    private final EventNotificationService notificationCallbackService;
    private final EmailSender emailSender;
    private final NotificationService notificationService;
    private final NodeId nodeId;

    @Inject
    public EmailEventNotification(EventNotificationService notificationCallbackService, EmailSender emailSender, NotificationService notificationService, NodeId nodeId) {
        this.notificationCallbackService = notificationCallbackService;
        this.emailSender = emailSender;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
    }

    @Override
    public void execute(EventNotificationContext ctx) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        EmailEventNotificationConfig config = (EmailEventNotificationConfig)ctx.notificationConfig();
        try {
            ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
            this.emailSender.sendEmails(config, ctx, backlog);
        }
        catch (EmailSender.ConfigurationError e) {
            throw new TemporaryEventNotificationException(e.getMessage());
        }
        catch (TransportConfigurationException e) {
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.EMAIL_TRANSPORT_CONFIGURATION_INVALID).addSeverity(Notification.Severity.NORMAL).addDetail("exception", e.getMessage());
            this.notificationService.publishIfFirst(systemNotification);
            throw new TemporaryEventNotificationException("Notification has email recipients and is triggered, but email transport is not configured. " + e.getMessage());
        }
        catch (Exception e) {
            Object exceptionDetail = e.toString();
            if (e.getCause() != null) {
                exceptionDetail = (String)exceptionDetail + " (" + e.getCause() + ")";
            }
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.EMAIL_TRANSPORT_FAILED).addSeverity(Notification.Severity.NORMAL).addDetail("exception", exceptionDetail);
            this.notificationService.publishIfFirst(systemNotification);
            throw new PermanentEventNotificationException("Notification has email recipients and is triggered, but sending emails failed. " + e.getMessage());
        }
        LOG.debug("Sending email to addresses <{}> and users <{}> using notification <{}>", new Object[]{Strings.join(config.emailRecipients(), (char)','), Strings.join(config.userRecipients(), (char)','), ctx.notificationId()});
    }

    public static interface Factory
    extends EventNotification.Factory {
        public EmailEventNotification create();
    }
}

