/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.HttpEventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.types.AutoValue_HTTPEventNotificationConfig;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.security.encryption.EncryptedValue;

@JsonTypeName(value="http-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class HTTPEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "http-notification-v1";
    private static final String FIELD_URL = "url";
    private static final String FIELD_BASIC_AUTH = "basic_auth";
    private static final String FIELD_API_KEY = "api_key";
    private static final String FIELD_API_SECRET = "api_secret";

    @JsonProperty(value="basic_auth")
    @Nullable
    public abstract EncryptedValue basicAuth();

    @JsonProperty(value="api_key")
    @Nullable
    public abstract String apiKey();

    @JsonProperty(value="api_secret")
    @Nullable
    public abstract EncryptedValue apiSecret();

    @JsonProperty(value="url")
    public abstract String url();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.url().isEmpty()) {
            validation.addError(FIELD_URL, "HTTP Notification url cannot be empty.");
        }
        if (Strings.isNullOrEmpty((String)this.apiKey()) && this.apiSecret() != null && this.apiSecret().isSet()) {
            validation.addError(FIELD_API_KEY, "HTTP Notification cannot specify API secret without API key");
        }
        if (!(Strings.isNullOrEmpty((String)this.apiKey()) || this.apiSecret() != null && (this.apiSecret().isSet() || this.apiSecret().isKeepValue()))) {
            validation.addError(FIELD_API_SECRET, "HTTP Notification cannot specify API key without API secret");
        }
        return validation;
    }

    @Override
    @JsonIgnore
    public EventNotificationConfig prepareConfigUpdate(@Nonnull EventNotificationConfig newConfig) {
        HTTPEventNotificationConfig newHttpConfig = (HTTPEventNotificationConfig)newConfig;
        EncryptedValue newBasicAuth = newHttpConfig.basicAuth();
        if (newHttpConfig.basicAuth() != null) {
            if (newHttpConfig.basicAuth().isKeepValue()) {
                newBasicAuth = this.basicAuth();
            } else if (newHttpConfig.basicAuth().isDeleteValue()) {
                newBasicAuth = EncryptedValue.createUnset();
            }
        }
        EncryptedValue newApiKeyValue = newHttpConfig.apiSecret();
        if (newHttpConfig.apiSecret() != null) {
            if (newHttpConfig.apiSecret().isKeepValue()) {
                newApiKeyValue = this.apiSecret();
            } else if (newHttpConfig.apiSecret().isDeleteValue()) {
                newApiKeyValue = EncryptedValue.createUnset();
            }
        }
        return newHttpConfig.toBuilder().apiSecret(newApiKeyValue).basicAuth(newBasicAuth).build();
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return HttpEventNotificationConfigEntity.builder().url(ValueReference.of(this.url())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return (Builder)new AutoValue_HTTPEventNotificationConfig.Builder().basicAuth(EncryptedValue.createUnset()).apiSecret(EncryptedValue.createUnset()).apiKey("").type(HTTPEventNotificationConfig.TYPE_NAME);
        }

        @JsonProperty(value="basic_auth")
        public abstract Builder basicAuth(EncryptedValue var1);

        @JsonProperty(value="api_key")
        public abstract Builder apiKey(String var1);

        @JsonProperty(value="api_secret")
        public abstract Builder apiSecret(EncryptedValue var1);

        @JsonProperty(value="url")
        public abstract Builder url(String var1);

        public abstract HTTPEventNotificationConfig build();
    }
}

