/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graylog.events.processor.DBEventProcessorStateService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedDbService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventDefinitionService
extends ScopedDbService<EventDefinitionDto> {
    private static final Logger LOG = LoggerFactory.getLogger(DBEventDefinitionService.class);
    private static final String COLLECTION_NAME = "event_definitions";
    private final DBEventProcessorStateService stateService;
    private final EntityOwnershipService entityOwnerShipService;

    @Inject
    public DBEventDefinitionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, DBEventProcessorStateService stateService, EntityOwnershipService entityOwnerShipService, EntityScopeService entityScopeService) {
        super(mongoConnection, mapper, EventDefinitionDto.class, COLLECTION_NAME, entityScopeService);
        this.stateService = stateService;
        this.entityOwnerShipService = entityOwnerShipService;
    }

    public PaginatedList<EventDefinitionDto> searchPaginated(SearchQuery query, Predicate<EventDefinitionDto> filter, String sortByField, int page, int perPage) {
        return this.findPaginatedWithQueryFilterAndSort(query.toDBQuery(), filter, this.getSortBuilder("asc", sortByField), page, perPage);
    }

    public EventDefinitionDto saveWithOwnership(EventDefinitionDto eventDefinitionDto, User user) {
        EventDefinitionDto dto = super.save(eventDefinitionDto);
        this.entityOwnerShipService.registerNewEventDefinition(dto.id(), user);
        return dto;
    }

    public int deleteUnregister(String id) {
        this.ensureMutability((EventDefinitionDto)this.get(id).orElseThrow(() -> new IllegalArgumentException("Event Definition not found.")));
        return this.doDeleteUnregister(id, () -> super.delete(id));
    }

    public int deleteUnregisterImmutable(String id) {
        return this.doDeleteUnregister(id, () -> super.deleteImmutable(id));
    }

    private int doDeleteUnregister(String id, Supplier<Integer> deleteSupplier) {
        try {
            this.stateService.deleteByEventDefinitionId(id);
        }
        catch (Exception e) {
            LOG.error("Couldn't delete event processor state for <{}>", (Object)id, (Object)e);
        }
        this.entityOwnerShipService.unregisterEventDefinition(id);
        return deleteSupplier.get();
    }

    public List<EventDefinitionDto> getByNotificationId(String notificationId) {
        String field = String.format(Locale.US, "%s.%s", "notifications", "notification_id");
        return ImmutableList.copyOf((Iterator)this.db.find(DBQuery.is((String)field, (Object)notificationId)).iterator());
    }
}

