/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventDefinitionEntity;
import org.graylog.events.contentpack.entities.EventNotificationHandlerConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.processor.$AutoValue_EventDefinitionDto;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.events.processor.storage.PersistToStreamsStorageHandler;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.entities.ScopedEntity;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.rest.ValidationResult;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventDefinitionDto
extends ScopedEntity
implements EventDefinition,
ContentPackable<EventDefinitionEntity> {
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_NOTIFICATIONS = "notifications";
    private static final String FIELD_PRIORITY = "priority";
    private static final String FIELD_ALERT = "alert";
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_FIELD_SPEC = "field_spec";
    private static final String FIELD_KEY_SPEC = "key_spec";
    private static final String FIELD_NOTIFICATION_SETTINGS = "notification_settings";
    private static final String FIELD_STORAGE = "storage";

    @Override
    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @Override
    @JsonProperty(value="title")
    public abstract String title();

    @Override
    @JsonProperty(value="description")
    public abstract String description();

    @Override
    @JsonProperty(value="priority")
    public abstract int priority();

    @Override
    @JsonProperty(value="alert")
    public abstract boolean alert();

    @Override
    @JsonProperty(value="config")
    public abstract EventProcessorConfig config();

    @Override
    @JsonProperty(value="field_spec")
    public abstract ImmutableMap<String, EventFieldSpec> fieldSpec();

    @Override
    @JsonProperty(value="key_spec")
    public abstract ImmutableList<String> keySpec();

    @Override
    @JsonProperty(value="notification_settings")
    public abstract EventNotificationSettings notificationSettings();

    @Override
    @JsonProperty(value="notifications")
    public abstract ImmutableList<EventNotificationHandler.Config> notifications();

    @Override
    @JsonProperty(value="storage")
    public abstract ImmutableList<EventStorageHandler.Config> storage();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.title().isEmpty()) {
            validation.addError(FIELD_TITLE, "Event Definition title cannot be empty.");
        }
        try {
            validation.addAll(this.config().validate());
        }
        catch (UnsupportedOperationException e) {
            validation.addError(FIELD_CONFIG, "Event Definition config type cannot be empty.");
        }
        for (Map.Entry fieldSpecEntry : this.fieldSpec().entrySet()) {
            String fieldName = (String)fieldSpecEntry.getKey();
            if (Message.validKey(fieldName)) continue;
            validation.addError(FIELD_FIELD_SPEC, "Event Definition field_spec contains invalid message field \"" + fieldName + "\"");
        }
        if (this.keySpec().stream().anyMatch(key -> !this.fieldSpec().containsKey(key))) {
            validation.addError(FIELD_KEY_SPEC, "Event Definition key_spec can only contain fields defined in field_spec.");
        }
        return validation;
    }

    @Override
    public EventDefinitionEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        EventProcessorConfig config = this.config();
        EventProcessorConfigEntity eventProcessorConfigEntity = (EventProcessorConfigEntity)config.toContentPackEntity(entityDescriptorIds);
        ImmutableList notificationList = ImmutableList.copyOf((Collection)this.notifications().stream().map(notification -> notification.toContentPackEntity(entityDescriptorIds)).collect(Collectors.toList()));
        return ((EventDefinitionEntity.Builder)EventDefinitionEntity.builder().scope(ValueReference.of(this.scope()))).title(ValueReference.of(this.title())).description(ValueReference.of(this.description())).priority(ValueReference.of(this.priority())).alert(ValueReference.of(this.alert())).config(eventProcessorConfigEntity).notifications((ImmutableList<EventNotificationHandlerConfigEntity>)notificationList).notificationSettings(this.notificationSettings()).fieldSpec(this.fieldSpec()).keySpec(this.keySpec()).storage(this.storage()).build();
    }

    @Override
    public void resolveNativeEntity(EntityDescriptor entityDescriptor, MutableGraph<EntityDescriptor> mutableGraph) {
        this.notifications().stream().map(EventNotificationHandler.Config::notificationId).forEach(id -> {
            EntityDescriptor depNotification = ((EntityDescriptor.Builder)((EntityDescriptor.Builder)EntityDescriptor.builder().id(ModelId.of(id))).type(ModelTypes.NOTIFICATION_V1)).build();
            mutableGraph.putEdge((Object)entityDescriptor, (Object)depNotification);
        });
        this.config().resolveNativeEntity(entityDescriptor, mutableGraph);
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ScopedEntity.AbstractBuilder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new $AutoValue_EventDefinitionDto.Builder().fieldSpec((ImmutableMap<String, EventFieldSpec>)ImmutableMap.of()).notifications((ImmutableList<EventNotificationHandler.Config>)ImmutableList.of()).storage((ImmutableList<EventStorageHandler.Config>)ImmutableList.of());
        }

        @Override
        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="priority")
        public abstract Builder priority(int var1);

        @JsonProperty(value="alert")
        public abstract Builder alert(boolean var1);

        @JsonProperty(value="config")
        public abstract Builder config(EventProcessorConfig var1);

        @JsonProperty(value="field_spec")
        public abstract Builder fieldSpec(ImmutableMap<String, EventFieldSpec> var1);

        @JsonProperty(value="key_spec")
        public abstract Builder keySpec(ImmutableList<String> var1);

        @JsonProperty(value="notification_settings")
        public abstract Builder notificationSettings(EventNotificationSettings var1);

        @JsonProperty(value="notifications")
        public abstract Builder notifications(ImmutableList<EventNotificationHandler.Config> var1);

        @JsonProperty(value="storage")
        public abstract Builder storage(ImmutableList<EventStorageHandler.Config> var1);

        abstract EventDefinitionDto autoBuild();

        public EventDefinitionDto build() {
            EventDefinitionDto dto = this.autoBuild();
            PersistToStreamsStorageHandler.Config withDefaultEventsStream = PersistToStreamsStorageHandler.Config.createWithDefaultEventsStream();
            if (dto.storage().stream().noneMatch(withDefaultEventsStream::equals)) {
                List handlersWithoutPersistToStreams = dto.storage().stream().filter(handler -> !"persist-to-streams-v1".equals(handler.type())).collect(Collectors.toList());
                return dto.toBuilder().storage((ImmutableList<EventStorageHandler.Config>)ImmutableList.builder().addAll(handlersWithoutPersistToStreams).add((Object)withDefaultEventsStream).build()).build();
            }
            return dto;
        }
    }
}

