/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.ast.AutoValue_Rule;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class Rule {
    private static final Logger LOG = LoggerFactory.getLogger(Rule.class);
    private transient Set<String> metricNames = Sets.newHashSet();
    private transient Meter globalExecuted;
    private transient Meter localExecuted;
    private transient Meter globalFailed;
    private transient Meter localFailed;
    private transient Meter globalMatched;
    private transient Meter localMatched;
    private transient Meter globalNotMatched;
    private transient Meter localNotMatched;

    @Nullable
    public abstract String id();

    public abstract String name();

    public abstract LogicalExpression when();

    public abstract Collection<Statement> then();

    public static Builder builder() {
        return new AutoValue_Rule.Builder();
    }

    public abstract Builder toBuilder();

    public Rule withId(String id) {
        return this.toBuilder().id(id).build();
    }

    public static Rule alwaysFalse(String name) {
        return Rule.builder().name(name).when(new BooleanExpression((Token)new CommonToken(-1), false)).then(Collections.emptyList()).build();
    }

    public void registerMetrics(MetricRegistry metricRegistry, String pipelineId, String stageId) {
        if (this.id() == null) {
            LOG.debug("Not registering metrics for unsaved rule {}", (Object)this.name());
            return;
        }
        if (this.id() != null) {
            this.globalExecuted = this.registerGlobalMeter(metricRegistry, "executed");
            this.localExecuted = this.registerLocalMeter(metricRegistry, pipelineId, stageId, "executed");
            this.globalFailed = this.registerGlobalMeter(metricRegistry, "failed");
            this.localFailed = this.registerLocalMeter(metricRegistry, pipelineId, stageId, "failed");
            this.globalMatched = this.registerGlobalMeter(metricRegistry, "matched");
            this.localMatched = this.registerLocalMeter(metricRegistry, pipelineId, stageId, "matched");
            this.globalNotMatched = this.registerGlobalMeter(metricRegistry, "not-matched");
            this.localNotMatched = this.registerLocalMeter(metricRegistry, pipelineId, stageId, "not-matched");
        }
    }

    private Meter registerGlobalMeter(MetricRegistry metricRegistry, String type) {
        String name = MetricRegistry.name(Rule.class, (String[])new String[]{this.id(), type});
        this.metricNames.add(name);
        return metricRegistry.meter(name);
    }

    private Meter registerLocalMeter(MetricRegistry metricRegistry, String pipelineId, String stageId, String type) {
        String name = MetricRegistry.name(Rule.class, (String[])new String[]{this.id(), pipelineId, stageId, type});
        this.metricNames.add(name);
        return metricRegistry.meter(name);
    }

    public MetricFilter metricsFilter() {
        if (this.id() == null) {
            return (name, metric) -> false;
        }
        return (name, metric) -> this.metricNames.contains(name);
    }

    public void markExecution() {
        if (this.id() != null) {
            this.globalExecuted.mark();
            this.localExecuted.mark();
        }
    }

    public void markMatch() {
        if (this.id() != null) {
            this.globalMatched.mark();
            this.localMatched.mark();
        }
    }

    public void markNonMatch() {
        if (this.id() != null) {
            this.globalNotMatched.mark();
            this.localNotMatched.mark();
        }
    }

    public void markFailure() {
        if (this.id() != null) {
            this.globalFailed.mark();
            this.localFailed.mark();
        }
    }

    public Rule copy() {
        return this.toBuilder().build();
    }

    public String toString() {
        return "Rule '" + this.name() + "' (" + this.id() + ")";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder when(LogicalExpression var1);

        public abstract Builder then(Collection<Statement> var1);

        public abstract Rule build();
    }
}

