/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NumericExpression;

public class MultiplicationExpression
extends BinaryExpression
implements NumericExpression {
    private final char operator;
    private Class type;

    public MultiplicationExpression(Token start, Expression left, Expression right, char operator) {
        super(start, left, right);
        this.operator = operator;
    }

    @Override
    public boolean isIntegral() {
        return this.getType().equals(Long.class);
    }

    @Override
    public long evaluateLong(EvaluationContext context) {
        return (Long)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0);
    }

    @Override
    public double evaluateDouble(EvaluationContext context) {
        return (Double)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0.0);
    }

    @Override
    @Nullable
    public Object evaluateUnsafe(EvaluationContext context) {
        Object leftValue = this.left.evaluateUnsafe(context);
        Object rightValue = this.right.evaluateUnsafe(context);
        if (this.isIntegral()) {
            long l = (Long)leftValue;
            long r = (Long)rightValue;
            switch (this.operator) {
                case '*': {
                    return l * r;
                }
                case '/': {
                    return l / r;
                }
                case '%': {
                    return l % r;
                }
            }
            throw new IllegalStateException("Invalid operator, this is a bug.");
        }
        double l = (Double)leftValue;
        double r = (Double)rightValue;
        switch (this.operator) {
            case '*': {
                return l * r;
            }
            case '/': {
                return l / r;
            }
            case '%': {
                return l % r;
            }
        }
        throw new IllegalStateException("Invalid operator, this is a bug.");
    }

    public char getOperator() {
        return this.operator;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String toString() {
        return this.left.toString() + " " + this.operator + " " + this.right.toString();
    }
}

