/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFlatten
extends AbstractFunction<JsonNode> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFlatten.class);
    public static final String NAME = "flatten_json";
    private static final String OPTION_JSON = "json";
    private static final String OPTION_FLATTEN = "flatten";
    private static final String OPTION_IGNORE = "ignore";
    public static final JsonUtils.ExtractFlags FLAGS_JSON = JsonUtils.ExtractFlags.builder().flattenObjects(true).escapeArrays(true).deleteArrays(false).build();
    public static final JsonUtils.ExtractFlags FLAGS_FLATTEN = JsonUtils.ExtractFlags.builder().flattenObjects(true).escapeArrays(false).deleteArrays(false).build();
    public static final JsonUtils.ExtractFlags FLAGS_IGNORE = JsonUtils.ExtractFlags.builder().flattenObjects(true).escapeArrays(false).deleteArrays(true).build();
    private final ObjectMapper objectMapper;
    private final ParameterDescriptor<String, String> valueParam;
    private final ParameterDescriptor<String, String> arrayHandlerParam;
    private final ParameterDescriptor<Boolean, Boolean> stringifyParam;

    @Inject
    public JsonFlatten(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.valueParam = ParameterDescriptor.string("value").description("The string to parse as a JSON tree").build();
        this.arrayHandlerParam = ParameterDescriptor.string("array_handler").description("Determines how arrays are processed").build();
        this.stringifyParam = ParameterDescriptor.bool("stringify").optional().description("Convert all extracted values to strings").build();
    }

    @Override
    public JsonNode evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        String arrayHandler = this.arrayHandlerParam.required(args, context);
        boolean stringify = this.stringifyParam.optional(args, context).orElse(false);
        try {
            switch (arrayHandler) {
                case "ignore": {
                    return JsonUtils.extractJson(value, this.objectMapper, FLAGS_IGNORE, stringify);
                }
                case "json": {
                    return JsonUtils.extractJson(value, this.objectMapper, FLAGS_JSON, stringify);
                }
                case "flatten": {
                    return JsonUtils.extractJson(value, this.objectMapper, FLAGS_FLATTEN, stringify);
                }
            }
            LOG.warn("Unknown parameter array_handler: {}", (Object)arrayHandler);
        }
        catch (IOException e) {
            LOG.warn("Unable to parse JSON", (Throwable)e);
        }
        return null;
    }

    @Override
    public FunctionDescriptor<JsonNode> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(JsonNode.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.arrayHandlerParam, this.stringifyParam)).description("Parses a string as a JSON tree, while flattening all containers to a single level").build();
    }
}

