/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.db.PaginatedRuleService;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.db.PipelineServiceHelper;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleMetricsConfigDto;
import org.graylog.plugins.pipelineprocessor.db.RuleMetricsConfigService;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.parser.FunctionRegistry;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rest.BulkRuleRequest;
import org.graylog.plugins.pipelineprocessor.rest.PipelineCompactSource;
import org.graylog.plugins.pipelineprocessor.rest.RuleSource;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Pipelines/Rules", description="Rules for the pipeline message processor", tags={"cloud"})
@Path(value="/system/pipelines/rule")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class RuleResource
extends RestResource
implements PluginRestResource {
    private static final Logger log = LoggerFactory.getLogger(RuleResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private final RuleService ruleService;
    private final PipelineService pipelineService;
    private final RuleMetricsConfigService ruleMetricsConfigService;
    private final PipelineRuleParser pipelineRuleParser;
    private final FunctionRegistry functionRegistry;
    private final PaginatedRuleService paginatedRuleService;
    private final SearchQueryParser searchQueryParser;
    private final PipelineServiceHelper pipelineServiceHelper;

    @Inject
    public RuleResource(RuleService ruleService, PipelineService pipelineService, RuleMetricsConfigService ruleMetricsConfigService, PipelineRuleParser pipelineRuleParser, PaginatedRuleService paginatedRuleService, FunctionRegistry functionRegistry, PipelineServiceHelper pipelineServiceHelper) {
        this.ruleService = ruleService;
        this.pipelineService = pipelineService;
        this.ruleMetricsConfigService = ruleMetricsConfigService;
        this.pipelineRuleParser = pipelineRuleParser;
        this.functionRegistry = functionRegistry;
        this.paginatedRuleService = paginatedRuleService;
        this.pipelineServiceHelper = pipelineServiceHelper;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @ApiOperation(value="Create a processing rule from source", notes="")
    @POST
    @RequiresPermissions(value={"pipeline_rule:create"})
    @AuditEvent(type="pipeline_processor:rule:create")
    public RuleSource createFromParser(@ApiParam(name="rule", required=true) @NotNull RuleSource ruleSource) throws ParseException {
        RuleDao save;
        Rule rule;
        try {
            rule = this.pipelineRuleParser.parseRule(ruleSource.id(), ruleSource.source(), false);
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        RuleDao newRuleSource = RuleDao.builder().title(rule.name()).description(ruleSource.description()).source(ruleSource.source()).createdAt(now).modifiedAt(now).build();
        try {
            save = this.ruleService.save(newRuleSource);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        log.debug("Created new rule {}", (Object)save);
        return RuleSource.fromDao(this.pipelineRuleParser, save);
    }

    @ApiOperation(value="Parse a processing rule without saving it", notes="")
    @POST
    @Path(value="/parse")
    @NoAuditEvent(value="only used to parse a rule, no changes made in the system")
    public RuleSource parse(@ApiParam(name="rule", required=true) @NotNull RuleSource ruleSource) throws ParseException {
        Rule rule;
        try {
            rule = this.pipelineRuleParser.parseRule(ruleSource.id(), ruleSource.source(), true);
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return RuleSource.builder().title(rule.name()).description(ruleSource.description()).source(ruleSource.source()).createdAt(now).modifiedAt(now).build();
    }

    @ApiOperation(value="Get all processing rules")
    @GET
    @RequiresPermissions(value={"pipeline_rule:read"})
    public Collection<RuleSource> getAll() {
        Collection<RuleDao> ruleDaos = this.ruleService.loadAll();
        return ruleDaos.stream().map(ruleDao -> RuleSource.fromDao(this.pipelineRuleParser, ruleDao)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/paginated")
    @ApiOperation(value="Get a paginated list of pipeline rules")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"pipeline_rule:read"})
    public PaginatedResponse<RuleSource> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,id") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<RuleDao> result = this.paginatedRuleService.findPaginated(searchQuery, page, perPage, sort, order);
        List ruleSourceList = result.stream().map(dao -> RuleSource.fromDao(this.pipelineRuleParser, dao)).collect(Collectors.toList());
        PaginatedList rules = new PaginatedList(ruleSourceList, result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        return PaginatedResponse.create("rules", rules, this.prepareContextForPaginatedResponse((List<RuleDao>)result.delegate()));
    }

    @Nonnull
    @VisibleForTesting
    Map<String, Object> prepareContextForPaginatedResponse(@Nonnull List<RuleDao> rules) {
        Map<String, RuleDao> ruleTitleMap = rules.stream().collect(Collectors.toMap(RuleDao::title, dao -> dao));
        HashMap result = new HashMap();
        rules.forEach(r -> result.put(r.id(), new ArrayList()));
        this.pipelineServiceHelper.groupByRuleName(this.pipelineService::loadAll, ruleTitleMap.keySet()).forEach((ruleTitle, pipelineDaos) -> result.put(((RuleDao)ruleTitleMap.get(ruleTitle)).id(), pipelineDaos.stream().map(dao -> PipelineCompactSource.builder().id(dao.id()).title(dao.title()).build()).collect(Collectors.toList())));
        return ImmutableMap.of((Object)"used_in_pipelines", result);
    }

    @ApiOperation(value="Get a processing rule", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @GET
    public RuleSource get(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline_rule:read", id);
        return RuleSource.fromDao(this.pipelineRuleParser, this.ruleService.load(id));
    }

    @ApiOperation(value="Retrieve the named processing rules in bulk")
    @Path(value="/multiple")
    @POST
    @NoAuditEvent(value="only used to get multiple pipeline rules")
    public Collection<RuleSource> getBulk(@ApiParam(value="rules") BulkRuleRequest rules) {
        Collection<RuleDao> ruleDaos = this.ruleService.loadNamed(rules.rules());
        return ruleDaos.stream().map(ruleDao -> RuleSource.fromDao(this.pipelineRuleParser, ruleDao)).filter(rule -> this.isPermitted("pipeline_rule:read", rule.id())).collect(Collectors.toList());
    }

    @ApiOperation(value="Modify a processing rule", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @PUT
    @AuditEvent(type="pipeline_processor:rule:update")
    public RuleSource update(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam(name="rule", required=true) @NotNull RuleSource update) throws NotFoundException {
        RuleDao savedRule;
        Rule rule;
        this.checkPermission("pipeline_rule:edit", id);
        RuleDao ruleDao = this.ruleService.load(id);
        try {
            rule = this.pipelineRuleParser.parseRule(id, update.source(), false);
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        RuleDao toSave = ruleDao.toBuilder().title(rule.name()).description(update.description()).source(update.source()).modifiedAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
        try {
            savedRule = this.ruleService.save(toSave);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return RuleSource.fromDao(this.pipelineRuleParser, savedRule);
    }

    @ApiOperation(value="Delete a processing rule", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @DELETE
    @AuditEvent(type="pipeline_processor:rule:delete")
    public void delete(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline_rule:delete", id);
        this.ruleService.load(id);
        this.ruleService.delete(id);
    }

    @ApiOperation(value="Get function descriptors")
    @Path(value="/functions")
    @GET
    public Collection<Object> functionDescriptors() {
        return this.functionRegistry.all().stream().map(Function::descriptor).collect(Collectors.toList());
    }

    @ApiOperation(value="Get rule metrics configuration")
    @Path(value="/config/metrics")
    @GET
    public RuleMetricsConfigDto metricsConfig() {
        return this.ruleMetricsConfigService.get();
    }

    @ApiOperation(value="Update rule metrics configuration")
    @Path(value="/config/metrics")
    @PUT
    @AuditEvent(type="pipeline_processor:rulemetrics:update")
    public RuleMetricsConfigDto updateMetricsConfig(RuleMetricsConfigDto config) {
        return this.ruleMetricsConfigService.save(config);
    }
}

