/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import org.graylog.plugins.views.search.rest.SeriesDescription;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MetricToSeriesSpecMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;

public class MetricsToSeriesSpecMapper
implements Function<Metric, SeriesSpec> {
    private final List<String> availableMetricTypes;
    private final MetricToSeriesSpecMapper seriesSpecCreator;

    @Inject
    public MetricsToSeriesSpecMapper(Map<String, SeriesDescription> availableFunctions, MetricToSeriesSpecMapper seriesSpecCreator) {
        this.availableMetricTypes = availableFunctions.values().stream().map(SeriesDescription::type).collect(Collectors.toList());
        this.seriesSpecCreator = seriesSpecCreator;
    }

    @Override
    public SeriesSpec apply(Metric metric) {
        if (!this.availableMetricTypes.contains(metric.functionName())) {
            throw new BadRequestException("Unrecognized metric : " + metric.functionName() + ", valid metrics : " + this.availableMetricTypes);
        }
        return this.seriesSpecCreator.apply(metric);
    }
}

