/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.parsing;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class ShortTimerangeFormatParser {
    private static final Pattern SHORT_FORMAT_PATTERN = Pattern.compile("^[0-9]+[a-zA-Z]$");
    private static final Map<String, String> SHORT_TO_LONG_PERIOD_MAPPING = Map.of("s", "seconds", "m", "minutes", "h", "hours", "d", "days", "w", "weeks", "M", "months", "y", "years");

    public Optional<TimeRange> parse(String shortTimerange) {
        if (shortTimerange != null && SHORT_FORMAT_PATTERN.matcher(shortTimerange).matches()) {
            String numberPart = shortTimerange.substring(0, shortTimerange.length() - 1);
            String periodPart = shortTimerange.substring(shortTimerange.length() - 1);
            String longPeriodPart = SHORT_TO_LONG_PERIOD_MAPPING.get(periodPart);
            if (longPeriodPart != null) {
                if ("1".equals(numberPart)) {
                    longPeriodPart = longPeriodPart.substring(0, longPeriodPart.length() - 1);
                }
                return Optional.of(KeywordRange.create("last " + numberPart + " " + longPeriodPart, "UTC"));
            }
        }
        return Optional.empty();
    }
}

