/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Grouping;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public record SearchRequestSpec(@JsonProperty(value="query") String queryString, @JsonProperty(value="streams") Set<String> streams, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="group_by") @Valid @NotEmpty List<Grouping> groupings, @JsonProperty(value="metrics") @Valid @NotEmpty List<Metric> metrics) {
    public static final RelativeRange DEFAULT_TIMERANGE = RelativeRange.create(86400);

    public SearchRequestSpec(@JsonProperty(value="query") String queryString, @JsonProperty(value="streams") Set<String> streams, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="group_by") @Valid @NotEmpty List<Grouping> groupings, @JsonProperty(value="metrics") @Valid @NotEmpty List<Metric> metrics) {
        if (Strings.isNullOrEmpty((String)queryString)) {
            queryString = "*";
        }
        if (timerange == null) {
            timerange = DEFAULT_TIMERANGE;
        }
        if (streams == null) {
            streams = Set.of();
        }
    }

    public boolean hasCustomSort() {
        return this.metrics().stream().anyMatch(m -> m.sort() != null);
    }
}

