/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.schedule.AutoValue_CronJobSchedule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="cron")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CronJobSchedule
implements JobSchedule {
    public static final String TYPE_NAME = "cron";
    public static final String FIELD_CRON_EXPRESSION = "cron_expression";
    public static final String FIELD_TIMEZONE = "timezone";
    public static final String DEFAULT_TIMEZONE = "UTC";

    @JsonProperty(value="cron_expression")
    public abstract String cronExpression();

    @JsonProperty(value="timezone")
    abstract Optional<String> timezone();

    private static CronParser newCronParser() {
        return new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }

    @Override
    public Optional<DateTime> calculateNextTime(DateTime previousExecutionTime, DateTime lastNextTime, JobSchedulerClock clock) {
        Cron cron = CronJobSchedule.newCronParser().parse(this.cronExpression());
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        ZonedDateTime zdt = this.getZonedDateTime(clock);
        return executionTime.nextExecution(zdt).map(this::toDateTime);
    }

    private ZonedDateTime getZonedDateTime(JobSchedulerClock clock) {
        DateTime now = clock.nowUTC();
        Instant instant = Instant.ofEpochMilli(now.getMillis());
        ZoneId zoneId = ZoneId.of(this.timezone().orElse(DEFAULT_TIMEZONE), ZoneId.SHORT_IDS);
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    private DateTime toDateTime(ZonedDateTime t) {
        DateTimeZone tz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(t.getZone()));
        return new DateTime(t.toInstant().toEpochMilli(), tz);
    }

    @Override
    public Optional<Map<String, Object>> toDBUpdate(String fieldPrefix) {
        return Optional.of(ImmutableMap.of((Object)(fieldPrefix + "type"), (Object)this.type(), (Object)(fieldPrefix + FIELD_CRON_EXPRESSION), (Object)this.cronExpression(), (Object)(fieldPrefix + FIELD_TIMEZONE), (Object)this.timezone().orElse(DEFAULT_TIMEZONE)));
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    implements JobSchedule.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_CronJobSchedule.Builder().type(CronJobSchedule.TYPE_NAME);
        }

        @JsonProperty(value="cron_expression")
        public abstract Builder cronExpression(String var1);

        @JsonProperty(value="timezone")
        public abstract Builder timezone(@Nullable String var1);

        abstract CronJobSchedule autoBuild();

        public CronJobSchedule build() {
            this.type(CronJobSchedule.TYPE_NAME);
            CronJobSchedule schedule = this.autoBuild();
            this.validateCronExpression(schedule);
            return schedule;
        }

        private void validateCronExpression(CronJobSchedule schedule) {
            Cron cron = CronJobSchedule.newCronParser().parse(schedule.cronExpression());
            cron.validate();
        }
    }
}

