/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import java.util.Optional;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthServiceException;
import org.graylog.security.authservice.AuthServiceResult;
import org.graylog.security.authservice.AuthServiceToken;
import org.graylog.security.authservice.AuthenticationDetails;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServiceAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthServiceAuthenticator.class);
    private final GlobalAuthServiceConfig authServiceConfig;
    private final ProvisionerService provisionerService;

    @Inject
    public AuthServiceAuthenticator(GlobalAuthServiceConfig authServiceConfig, ProvisionerService provisionerService) {
        this.authServiceConfig = authServiceConfig;
        this.provisionerService = provisionerService;
    }

    public AuthServiceResult authenticate(AuthServiceToken token) {
        Optional<AuthServiceBackend> activeBackend = this.authServiceConfig.getActiveBackend();
        if (!activeBackend.isPresent()) {
            AuthServiceBackend defaultBackend = this.authServiceConfig.getDefaultBackend();
            throw new AuthServiceException("No active auth service backend configured. Tokens can not be authenticated with the default backend. Please activate a backend capable of token-based authentication.", defaultBackend.backendType(), defaultBackend.backendId());
        }
        return this.authenticate(token, activeBackend.get());
    }

    public AuthServiceResult authenticate(AuthServiceCredentials authCredentials) {
        Optional<AuthServiceBackend> activeBackend = this.authServiceConfig.getActiveBackend();
        if (activeBackend.isPresent()) {
            AuthServiceResult result;
            AuthenticationServiceUnavailableException caughtException = null;
            try {
                result = this.authenticate(authCredentials, activeBackend.get());
                if (result.isSuccess()) {
                    return result;
                }
            }
            catch (AuthenticationServiceUnavailableException e) {
                caughtException = e;
            }
            if (LOG.isDebugEnabled()) {
                AuthServiceBackend defaultBackend = this.authServiceConfig.getDefaultBackend();
                LOG.debug("Couldn't authenticate <{}> against active authentication service <{}/{}/{}>. Trying default backend <{}/{}/{}>.", new Object[]{authCredentials.username(), activeBackend.get().backendId(), activeBackend.get().backendType(), activeBackend.get().backendTitle(), defaultBackend.backendId(), defaultBackend.backendType(), defaultBackend.backendTitle()});
            }
            if ((result = this.authenticate(authCredentials, this.authServiceConfig.getDefaultBackend())).isSuccess()) {
                return result;
            }
            if (caughtException != null) {
                throw caughtException;
            }
            return result;
        }
        return this.authenticate(authCredentials, this.authServiceConfig.getDefaultBackend());
    }

    private AuthServiceResult authenticate(AuthServiceToken token, AuthServiceBackend backend) {
        Optional<AuthenticationDetails> optionalAuthDetails = backend.authenticateAndProvision(token, this.provisionerService);
        return optionalAuthDetails.map(authDetails -> this.successResult((AuthenticationDetails)authDetails, backend)).orElseGet(() -> this.failResult("<token>", backend));
    }

    private AuthServiceResult authenticate(AuthServiceCredentials authCredentials, AuthServiceBackend backend) {
        Optional<AuthenticationDetails> optionalAuthenticationDetails = backend.authenticateAndProvision(authCredentials, this.provisionerService);
        return optionalAuthenticationDetails.map(authDetails -> this.successResult((AuthenticationDetails)authDetails, backend)).orElseGet(() -> this.failResult(authCredentials.username(), backend));
    }

    private AuthServiceResult successResult(AuthenticationDetails authDetails, AuthServiceBackend backend) {
        return AuthServiceResult.builder().username(authDetails.userDetails().username()).userProfileId(authDetails.userDetails().databaseId().get()).backendType(backend.backendType()).backendId(backend.backendId()).backendTitle(backend.backendTitle()).sessionAttributes(authDetails.sessionAttributes()).build();
    }

    private AuthServiceResult failResult(String username, AuthServiceBackend backend) {
        return AuthServiceResult.failed(username, backend);
    }
}

