/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades.dashboardV1;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.views.WidgetConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.AggregationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.AreaVisualizationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.AutoIntervalDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.BarVisualizationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.Interpolation;
import org.graylog.plugins.views.search.views.widgets.aggregation.LineVisualizationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.NumberVisualizationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.PivotDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.SeriesConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.SeriesDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.TimeHistogramConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.ValueConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.VisualizationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.PivotSortConfig;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.SortConfigDTO;
import org.graylog2.contentpacks.model.entities.DashboardWidgetEntity;
import org.graylog2.contentpacks.model.entities.WidgetConfig;
import org.graylog2.contentpacks.model.entities.WidgetEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

public class DashboardWidgetConverter {
    private Map<String, ValueReference> parameters;
    private DashboardWidgetEntity dashboardWidgetEntity;
    private WidgetConfig config;

    public List<WidgetEntity> convert(DashboardWidgetEntity dashboardWidgetEntity, Map<String, ValueReference> parameters) {
        this.dashboardWidgetEntity = dashboardWidgetEntity;
        this.config = new WidgetConfig(dashboardWidgetEntity.configuration(), parameters);
        this.parameters = parameters;
        String type = dashboardWidgetEntity.type().asString(parameters);
        switch (type.toUpperCase(Locale.ENGLISH)) {
            case "SEARCH_RESULT_CHART": {
                return this.createHistogramWidget();
            }
            case "FIELD_CHART": {
                return this.createFieldChartWidget();
            }
            case "STACKED_CHART": {
                return this.createStackedChartWidget();
            }
            case "STATS_COUNT": {
                return this.createStatsCountWidget();
            }
            case "QUICKVALUES": {
                return this.createQuickValueWidgets();
            }
            case "STREAM_SEARCH_RESULT_COUNT": 
            case "SEARCH_RESULT_COUNT": {
                return this.createSearchResultCount();
            }
            case "QUICKVALUES_HISTOGRAM": {
                return this.createQuickValueHistogramWidgets();
            }
            case "ORG.GRAYLOG.PLUGINS.MAP.WIDGET.STRATEGY.MAPWIDGETSTRATEGY": {
                return this.createMapWidget();
            }
        }
        throw new RuntimeException("The provided entity does not have a valid Widget type: " + type);
    }

    private WidgetConfigDTO defaultWidgetConfig() {
        return AggregationConfigDTO.Builder.builder().series((List<SeriesDTO>)ImmutableList.of((Object)SeriesDTO.Builder.create().config(SeriesConfigDTO.empty()).function("count()").build())).rowPivots((List<PivotDTO>)ImmutableList.of((Object)PivotDTO.Builder.builder().type("time").field("timestamp").config(TimeHistogramConfigDTO.Builder.builder().interval(AutoIntervalDTO.Builder.builder().build()).build()).build())).visualization("bar").columnPivots(Collections.emptyList()).sort(Collections.emptyList()).build();
    }

    private WidgetEntity.Builder aggregationWidgetBuilder() {
        WidgetEntity.Builder widgetEntityBuilder = WidgetEntity.builder().type("aggregation").id(UUID.randomUUID().toString()).timerange(this.dashboardWidgetEntity.timeRange().convert(this.parameters));
        Optional<String> streamId = this.config.getOptionalString("stream_id");
        if (streamId.isPresent()) {
            ImmutableSet.Builder streams = new ImmutableSet.Builder();
            streams.add((Object)streamId.get());
            widgetEntityBuilder.streams((Set<String>)streams.build());
        }
        return widgetEntityBuilder;
    }

    private List<WidgetEntity> createHistogramWidget() {
        WidgetConfigDTO widgetConfigDTO = this.defaultWidgetConfig();
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder().config(widgetConfigDTO);
        Optional<String> query = this.config.getOptionalString("query");
        query.ifPresent(s -> widgetEntityBuilder.query(ElasticsearchQueryString.of(s)));
        return ImmutableList.of((Object)widgetEntityBuilder.build());
    }

    private String mapRendererToVisualization(String renderer) {
        switch (renderer) {
            case "bar": 
            case "line": 
            case "area": {
                return renderer;
            }
            case "scatterplot": {
                return "scatter";
            }
        }
        throw new RuntimeException("Unable to map renderer to visualization: " + renderer);
    }

    private Interpolation fromLegacyInterpolation(String legacyValue) {
        switch (legacyValue) {
            case "linear": {
                return Interpolation.linear;
            }
            case "step-after": {
                return Interpolation.stepAfter;
            }
            case "cardinal": 
            case "basis": 
            case "bundle": 
            case "monotone": {
                return Interpolation.spline;
            }
        }
        throw new RuntimeException("Invalid interpolation value: " + legacyValue);
    }

    private Optional<VisualizationConfigDTO> createVisualizationConfig() {
        String renderer = this.config.getString("renderer");
        String interpolation = this.config.getString("interpolation");
        switch (renderer) {
            case "line": {
                return Optional.of(LineVisualizationConfigDTO.Builder.builder().interpolation(this.fromLegacyInterpolation(interpolation)).build());
            }
            case "area": {
                return Optional.of(AreaVisualizationConfigDTO.Builder.builder().interpolation(this.fromLegacyInterpolation(interpolation)).build());
            }
        }
        return Optional.empty();
    }

    private WidgetEntity fieldChartWidget(String renderer, String valueType, String field, String query) {
        AggregationConfigDTO.Builder configBuilder = AggregationConfigDTO.Builder.builder().series((List<SeriesDTO>)ImmutableList.of((Object)this.createSeriesDTO(valueType, field))).visualization(this.mapRendererToVisualization(renderer)).columnPivots(Collections.emptyList()).sort(Collections.emptyList()).rowPivots(Collections.singletonList(PivotDTO.Builder.builder().field("timestamp").type("time").config(TimeHistogramConfigDTO.Builder.builder().interval(AutoIntervalDTO.Builder.builder().build()).build()).build()));
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder();
        widgetEntityBuilder.query(ElasticsearchQueryString.of(query));
        return widgetEntityBuilder.config(this.createVisualizationConfig().map(configBuilder::visualizationConfig).orElse(configBuilder).build()).build();
    }

    private List<WidgetEntity> createFieldChartWidget() {
        String renderer = this.config.getString("renderer");
        String valueType = this.config.getString("valuetype");
        String field = this.config.getString("field");
        String query = this.config.getOptionalString("query").orElse("");
        return ImmutableList.of((Object)this.fieldChartWidget(renderer, valueType, field, query));
    }

    private List<WidgetEntity> createStackedChartWidget() {
        String renderer = this.config.getString("renderer");
        List<Object> series = this.config.getList("series");
        return series.stream().map(seriesConfig -> {
            String valueType = (String)seriesConfig.get("statistical_function");
            String field = (String)seriesConfig.get("field");
            String query = seriesConfig.getOrDefault("query", "");
            return this.fieldChartWidget(renderer, valueType, field, query);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<WidgetEntity> createStatsCountWidget() {
        String function = this.config.getString("stats_function");
        String field = this.config.getString("field");
        boolean trend = this.config.getBoolean("trend");
        boolean lowerIsBetter = this.config.getBoolean("lower_is_better");
        AggregationConfigDTO widgetConfig = AggregationConfigDTO.Builder.builder().series((List<SeriesDTO>)ImmutableList.of((Object)this.createSeriesDTO(function, field))).visualization("numeric").visualizationConfig(NumberVisualizationConfigDTO.Builder.builder().trend(trend).trendPreference(lowerIsBetter ? NumberVisualizationConfigDTO.TrendPreference.LOWER : NumberVisualizationConfigDTO.TrendPreference.HIGHER).build()).rowPivots(Collections.emptyList()).columnPivots(Collections.emptyList()).sort(Collections.emptyList()).build();
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder().config(widgetConfig);
        Optional<String> query = this.config.getOptionalString("query");
        query.ifPresent(s -> widgetEntityBuilder.query(ElasticsearchQueryString.of(s)));
        return ImmutableList.of((Object)widgetEntityBuilder.build());
    }

    private List<WidgetEntity> createQuickValueWidgets() {
        ArrayList<WidgetEntity> result = new ArrayList<WidgetEntity>(2);
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder();
        boolean showChart = this.config.getOptionalBoolean("show_pie_chart").orElse(false);
        boolean showTable = this.config.getOptionalBoolean("show_data_table").orElse(!showChart);
        String field = this.config.getString("field");
        String stackedFields = this.config.getOptionalString("stacked_fields").orElse("");
        Integer limit = this.config.getOptionalInteger("limit").orElse(5);
        Integer dataTableLimit = this.config.getOptionalInteger("data_table_limit").orElse(15);
        String sortOrder = this.config.getOptionalString("sort_order").orElse("desc");
        SortConfigDTO.Direction dir = sortOrder.matches("desc") ? SortConfigDTO.Direction.Descending : SortConfigDTO.Direction.Ascending;
        AggregationConfigDTO.Builder aggregationConfigBuilder = AggregationConfigDTO.Builder.builder().columnPivots(Collections.emptyList()).series((List<SeriesDTO>)ImmutableList.of((Object)SeriesDTO.Builder.create().config(SeriesConfigDTO.empty()).function("count()").build())).sort((List<SortConfigDTO>)ImmutableList.of((Object)PivotSortConfig.create(field, dir)));
        Optional<String> query = this.config.getOptionalString("query");
        query.ifPresent(s -> widgetEntityBuilder.query(ElasticsearchQueryString.of(s)));
        if (showChart) {
            result.add(widgetEntityBuilder.config(aggregationConfigBuilder.rowPivots(this.genPivotForPie(field, stackedFields)).optionalRowLimit(limit).visualization("pie").build()).build());
        }
        if (showTable) {
            result.add(widgetEntityBuilder.config(aggregationConfigBuilder.visualization("table").rowPivots(this.genPivotForPie(field, stackedFields)).optionalRowLimit(dataTableLimit).build()).id(UUID.randomUUID().toString()).build());
        }
        return result;
    }

    private List<WidgetEntity> createSearchResultCount() {
        boolean trend = this.config.getBoolean("trend");
        boolean lowerIsBetter = this.config.getBoolean("lower_is_better");
        AggregationConfigDTO widgetConfig = AggregationConfigDTO.Builder.builder().series((List<SeriesDTO>)ImmutableList.of((Object)this.createSeriesDTO("count", ""))).visualization("numeric").visualizationConfig(NumberVisualizationConfigDTO.Builder.builder().trend(trend).trendPreference(lowerIsBetter ? NumberVisualizationConfigDTO.TrendPreference.LOWER : NumberVisualizationConfigDTO.TrendPreference.HIGHER).build()).rowPivots(Collections.emptyList()).columnPivots(Collections.emptyList()).sort(Collections.emptyList()).build();
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder().config(widgetConfig);
        return ImmutableList.of((Object)widgetEntityBuilder.build());
    }

    private List<WidgetEntity> createQuickValueHistogramWidgets() {
        ArrayList<WidgetEntity> result = new ArrayList<WidgetEntity>(2);
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder();
        String stackedFields = this.config.getOptionalString("stacked_fields").orElse("");
        String field = this.config.getString("field");
        int limit = this.config.getOptionalInteger("limit").orElse(5);
        String sortOrder = this.config.getOptionalString("sort_order").orElse("desc");
        SortConfigDTO.Direction dir = sortOrder.matches("desc") ? SortConfigDTO.Direction.Descending : SortConfigDTO.Direction.Ascending;
        AggregationConfigDTO.Builder aggregationConfigBuilder = AggregationConfigDTO.Builder.builder().columnPivots(Collections.emptyList()).series((List<SeriesDTO>)ImmutableList.of((Object)SeriesDTO.Builder.create().config(SeriesConfigDTO.empty()).function("count()").build())).sort((List<SortConfigDTO>)ImmutableList.of((Object)PivotSortConfig.create(field, dir)));
        Optional<String> query = this.config.getOptionalString("query");
        query.ifPresent(s -> widgetEntityBuilder.query(ElasticsearchQueryString.of(s)));
        result.add(widgetEntityBuilder.config(aggregationConfigBuilder.visualization("bar").visualizationConfig(BarVisualizationConfigDTO.Builder.builder().barmode(BarVisualizationConfigDTO.BarMode.stack).build()).rollup(false).rowPivots(Collections.singletonList(PivotDTO.Builder.builder().field("timestamp").type("time").config(TimeHistogramConfigDTO.Builder.builder().interval(AutoIntervalDTO.Builder.builder().build()).build()).build())).columnPivots(this.genPivotForPie(field, stackedFields)).optionalColumnLimit(limit).build()).id(UUID.randomUUID().toString()).build());
        return result;
    }

    private List<WidgetEntity> createMapWidget() {
        String field = this.config.getString("field");
        PivotDTO fieldPivot = PivotDTO.Builder.builder().type("values").config(ValueConfigDTO.create()).field(field).build();
        AggregationConfigDTO widgetConfig = AggregationConfigDTO.Builder.builder().series((List<SeriesDTO>)ImmutableList.of((Object)this.createSeriesDTO("count", ""))).visualization("map").rowPivots((List<PivotDTO>)ImmutableList.of((Object)fieldPivot)).columnPivots(Collections.emptyList()).sort(Collections.emptyList()).build();
        WidgetEntity.Builder widgetEntityBuilder = this.aggregationWidgetBuilder().config(widgetConfig);
        Optional<String> query = this.config.getOptionalString("query");
        query.ifPresent(s -> widgetEntityBuilder.query(ElasticsearchQueryString.of(s)));
        return ImmutableList.of((Object)widgetEntityBuilder.build());
    }

    private List<PivotDTO> genPivotForPie(String field, String stackedFields) {
        PivotDTO fieldPivot = PivotDTO.Builder.builder().type("values").field(field).config(ValueConfigDTO.create()).build();
        ArrayList<PivotDTO> rowPivots = new ArrayList<PivotDTO>(this.stackedFieldPivots(stackedFields));
        rowPivots.add(fieldPivot);
        return rowPivots;
    }

    private List<PivotDTO> stackedFieldPivots(String fieldNames) {
        return Strings.isNullOrEmpty((String)fieldNames) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)fieldNames).stream().map(fieldName -> PivotDTO.Builder.builder().field((String)fieldName).type("values").config(ValueConfigDTO.create()).build()).collect(Collectors.toList());
    }

    private SeriesDTO createSeriesDTO(String valueType, String field) {
        return SeriesDTO.Builder.create().config(SeriesConfigDTO.empty()).function((switch (valueType) {
            case "cardinality" -> "card";
            case "mean" -> "avg";
            case "total" -> "sum";
            case "std_dev", "std_deviation" -> "stddev";
            default -> valueType;
        }) + "(" + field + ")").build();
    }
}

