/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.indexer.cluster.Cluster;

@Singleton
public class NodeInfoCache {
    private static final Duration EXPIRE_DURATION = Duration.minutes((long)1L);
    private final LoadingCache<String, Optional<String>> nodeNameCache = CacheBuilder.newBuilder().expireAfterWrite(EXPIRE_DURATION.getQuantity(), EXPIRE_DURATION.getUnit()).build(CacheLoader.from(cluster::nodeIdToName));
    private final LoadingCache<String, Optional<String>> hostNameCache = CacheBuilder.newBuilder().expireAfterWrite(EXPIRE_DURATION.getQuantity(), EXPIRE_DURATION.getUnit()).build(CacheLoader.from(cluster::nodeIdToHostName));

    @Inject
    public NodeInfoCache(Cluster cluster) {
    }

    public Optional<String> getNodeName(String nodeId) {
        return (Optional)this.nodeNameCache.getUnchecked((Object)nodeId);
    }

    public Optional<String> getHostName(String nodeId) {
        return (Optional)this.hostNameCache.getUnchecked((Object)nodeId);
    }
}

