/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ByteProcessor;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class SyslogOctetCountFrameDecoder
extends ByteToMessageDecoder {
    private static final ByteProcessor BYTE_PROCESSOR = value -> value != 32;

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        int frameSizeValueLength = this.findFrameSizeValueLength(buffer);
        if (frameSizeValueLength <= 0) {
            return;
        }
        String lengthString = buffer.slice(buffer.readerIndex(), frameSizeValueLength).toString(StandardCharsets.UTF_8);
        int length = Integer.parseInt(lengthString);
        int skipLength = frameSizeValueLength + 1;
        if (buffer.readableBytes() - skipLength < length) {
            return;
        }
        buffer.skipBytes(skipLength);
        ByteBuf frame = buffer.readRetainedSlice(length);
        out.add(frame);
    }

    private int findFrameSizeValueLength(ByteBuf buffer) {
        int readerIndex = buffer.readerIndex();
        int index = buffer.forEachByte(BYTE_PROCESSOR);
        if (index >= 0) {
            return index - readerIndex;
        }
        return -1;
    }
}

