/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.github.joschi.jadconfig.util.Size;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.netty.DatagramChannelFactory;
import org.graylog2.inputs.transports.netty.DatagramPacketHandler;
import org.graylog2.inputs.transports.netty.EnvelopeMessageAggregationHandler;
import org.graylog2.inputs.transports.netty.EnvelopeMessageHandler;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.inputs.transports.netty.NettyTransportType;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.NettyTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
extends NettyTransport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransport.class);
    private final NettyTransportConfiguration nettyTransportConfiguration;
    private final ChannelGroup channels;
    private EventLoopGroup eventLoopGroup;
    private Bootstrap bootstrap;

    @AssistedInject
    public UdpTransport(@Assisted Configuration configuration, EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration nettyTransportConfiguration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry) {
        super(configuration, eventLoopGroupFactory, throughputCounter, localRegistry);
        this.nettyTransportConfiguration = nettyTransportConfiguration;
        this.channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    @VisibleForTesting
    Bootstrap getBootstrap(MessageInput input) {
        LOG.debug("Setting UDP receive buffer size to {} bytes", (Object)this.getRecvBufferSize());
        NettyTransportType transportType = this.nettyTransportConfiguration.getType();
        this.eventLoopGroup = this.eventLoopGroupFactory.create(this.workerThreads, this.localRegistry, "workers");
        return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channelFactory((ChannelFactory)new DatagramChannelFactory(transportType))).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(65535))).option(ChannelOption.SO_RCVBUF, (Object)this.getRecvBufferSize())).option(UnixChannelOption.SO_REUSEPORT, (Object)true)).handler(this.getChannelInitializer(this.getChannelHandlers(input)))).validate();
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlers = new LinkedHashMap<String, Callable<? extends ChannelHandler>>(super.getChannelHandlers(input));
        handlers.put("traffic-counter", () -> this.throughputCounter);
        handlers.put("udp-datagram", () -> DatagramPacketHandler.INSTANCE);
        handlers.putAll(this.getChildChannelHandlers(input));
        return handlers;
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChildChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlerList = new LinkedHashMap<String, Callable<? extends ChannelHandler>>(this.getCustomChildChannelHandlers(input));
        CodecAggregator aggregator = this.getAggregator();
        if (aggregator != null) {
            LOG.debug("Adding codec aggregator {} to channel pipeline", (Object)aggregator);
            handlerList.put("codec-aggregator", () -> new EnvelopeMessageAggregationHandler(aggregator, this.localRegistry));
        }
        handlerList.put("envelope-message-handler", () -> new EnvelopeMessageHandler(input));
        return handlerList;
    }

    @Override
    public void launch(MessageInput input) throws MisfireException {
        try {
            this.bootstrap = this.getBootstrap(input);
            NettyTransportType transportType = this.nettyTransportConfiguration.getType();
            int numChannels = transportType == NettyTransportType.EPOLL || transportType == NettyTransportType.KQUEUE ? this.workerThreads : 1;
            for (int i = 0; i < numChannels; ++i) {
                LOG.debug("Starting channel on {}", (Object)this.socketAddress);
                this.bootstrap.bind((SocketAddress)this.socketAddress).addListener((GenericFutureListener)new InputLaunchListener(this.channels, input, this.getRecvBufferSize())).syncUninterruptibly();
            }
        }
        catch (Exception e) {
            throw new MisfireException(e);
        }
    }

    @Override
    public void stop() {
        if (this.channels != null) {
            this.channels.close().syncUninterruptibly();
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
        this.bootstrap = null;
    }

    @Override
    @Nullable
    public SocketAddress getLocalAddress() {
        if (this.channels != null) {
            return this.channels.stream().findFirst().map(Channel::localAddress).orElse(null);
        }
        return null;
    }

    private static class InputLaunchListener
    implements ChannelFutureListener {
        private final ChannelGroup channels;
        private final MessageInput input;
        private final int expectedRecvBufferSize;

        public InputLaunchListener(ChannelGroup channels, MessageInput input, int expectedRecvBufferSize) {
            this.channels = channels;
            this.input = input;
            this.expectedRecvBufferSize = expectedRecvBufferSize;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                this.channels.add((Object)channel);
                LOG.debug("Started channel {}", (Object)channel);
                DatagramChannelConfig channelConfig = (DatagramChannelConfig)channel.config();
                int receiveBufferSize = channelConfig.getReceiveBufferSize();
                if (receiveBufferSize < this.expectedRecvBufferSize) {
                    LOG.warn("receiveBufferSize (SO_RCVBUF) for input {} (channel {}) should be >= {} but is {}.", new Object[]{this.input, channel, this.expectedRecvBufferSize, receiveBufferSize});
                }
            } else {
                LOG.warn("Failed to start channel for input {}", (Object)this.input, (Object)future.cause());
            }
        }
    }

    @ConfigClass
    public static class Config
    extends NettyTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            int recvBufferSize = Ints.saturatedCast((long)Size.kilobytes((long)256L).toBytes());
            r.addField(ConfigurationRequest.Templates.recvBufferSize("recv_buffer_size", recvBufferSize));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<UdpTransport> {
        @Override
        public UdpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

