/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.lookup.;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;

@AutoValue
public abstract class LookupTable {
    @Nullable
    public abstract String id();

    public abstract String title();

    public abstract String description();

    public abstract String name();

    public abstract LookupCache cache();

    public abstract LookupDataAdapter dataAdapter();

    public abstract LookupDefaultSingleValue defaultSingleValue();

    public abstract LookupDefaultMultiValue defaultMultiValue();

    public static Builder builder() {
        return new .AutoValue_LookupTable.Builder();
    }

    @Nullable
    public String error() {
        return Streams.concat((Stream[])new Stream[]{Streams.stream(this.dataAdapter().getError()), Streams.stream(this.cache().getError())}).map(Throwable::getMessage).collect(Collectors.joining("\n"));
    }

    @Nullable
    public LookupResult lookup(@Nonnull Object key) {
        LookupResult result = this.cache().get(LookupCacheKey.create(this.dataAdapter(), key), () -> this.dataAdapter().get(key));
        if (result.hasError()) {
            return result;
        }
        if (result.isEmpty()) {
            return LookupResult.addDefaults(this.defaultSingleValue(), this.defaultMultiValue()).hasError(result.hasError()).build();
        }
        return result;
    }

    public LookupResult setValue(@Nonnull Object key, @Nonnull Object value) {
        LookupResult result = this.dataAdapter().setValue(key, value);
        this.cache().purge(LookupCacheKey.create(this.dataAdapter(), key));
        return result;
    }

    public LookupResult setStringList(@Nonnull Object key, @Nonnull List<String> value) {
        LookupResult result = this.dataAdapter().setStringList(key, value);
        this.cache().purge(LookupCacheKey.create(this.dataAdapter(), key));
        return result;
    }

    public LookupResult addStringList(@Nonnull Object key, @Nonnull List<String> value, boolean keepDuplicates) {
        LookupResult result = this.dataAdapter().addStringList(key, value, keepDuplicates);
        this.cache().purge(LookupCacheKey.create(this.dataAdapter(), key));
        return result;
    }

    public LookupResult removeStringList(@Nonnull Object key, @Nonnull List<String> value) {
        LookupResult result = this.dataAdapter().removeStringList(key, value);
        this.cache().purge(LookupCacheKey.create(this.dataAdapter(), key));
        return result;
    }

    public void clearKey(@Nonnull Object key) {
        this.dataAdapter().clearKey(key);
        this.cache().purge(LookupCacheKey.create(this.dataAdapter(), key));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder name(String var1);

        public abstract Builder cache(LookupCache var1);

        public abstract Builder dataAdapter(LookupDataAdapter var1);

        public abstract Builder defaultSingleValue(LookupDefaultSingleValue var1);

        public abstract Builder defaultMultiValue(LookupDefaultMultiValue var1);

        public abstract LookupTable build();
    }
}

