/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedDbService;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.events.CachesDeleted;
import org.graylog2.lookup.events.CachesUpdated;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBCacheService
extends ScopedDbService<CacheDto> {
    public static final String COLLECTION_NAME = "lut_caches";
    private final ClusterEventBus clusterEventBus;

    @Inject
    public DBCacheService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        super(mongoConnection, mapper, CacheDto.class, COLLECTION_NAME, entityScopeService);
        this.clusterEventBus = clusterEventBus;
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public Optional<CacheDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return Optional.ofNullable((CacheDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        return Optional.ofNullable((CacheDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
    }

    public CacheDto saveAndPostEvent(CacheDto table) {
        CacheDto savedCache = this.save(table);
        this.clusterEventBus.post(CachesUpdated.create(savedCache.id()));
        return savedCache;
    }

    public void postBulkUpdate(Set<String> updatedCacheIds) {
        this.clusterEventBus.post(CachesUpdated.create(updatedCacheIds));
    }

    public PaginatedList<CacheDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<CacheDto> paginatedList = new PaginatedList<CacheDto>((List<CacheDto>)this.asImmutableList(cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<CacheDto> cacheDto = this.get(idOrName);
        this.delete(idOrName);
        cacheDto.ifPresent(cache -> this.clusterEventBus.post(CachesDeleted.create(cache.id())));
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<CacheDto> cacheDto = this.get(idOrName);
        super.deleteImmutable(idOrName);
        cacheDto.ifPresent(cache -> this.clusterEventBus.post(CachesDeleted.create(cache.id())));
    }

    public Collection<CacheDto> findByIds(Set<String> idSet) {
        DBQuery.Query query = DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }

    public Collection<CacheDto> findAll() {
        try (DBCursor cursor = this.db.find();){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }
}

