/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedDbService;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.events.DataAdaptersDeleted;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBDataAdapterService
extends ScopedDbService<DataAdapterDto> {
    public static final String COLLECTION_NAME = "lut_data_adapters";
    private final ClusterEventBus clusterEventBus;

    @Inject
    public DBDataAdapterService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        super(mongoConnection, mapper, DataAdapterDto.class, COLLECTION_NAME, entityScopeService);
        this.clusterEventBus = clusterEventBus;
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public Optional<DataAdapterDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return Optional.ofNullable((DataAdapterDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        return Optional.ofNullable((DataAdapterDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
    }

    public DataAdapterDto saveAndPostEvent(DataAdapterDto table) {
        DataAdapterDto savedDataAdapter = super.save(table);
        this.clusterEventBus.post(DataAdaptersUpdated.create(savedDataAdapter.id()));
        return savedDataAdapter;
    }

    public void postBulkUpdate(Set<String> updatedAdapterIds) {
        this.clusterEventBus.post(DataAdaptersUpdated.create(updatedAdapterIds));
    }

    public PaginatedList<DataAdapterDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<DataAdapterDto> paginatedList = new PaginatedList<DataAdapterDto>((List<DataAdapterDto>)this.asImmutableList(cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.get(idOrName);
        super.delete(idOrName);
        dataAdapterDto.ifPresent(dataAdapter -> this.clusterEventBus.post(DataAdaptersDeleted.create(dataAdapter.id())));
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.get(idOrName);
        super.deleteImmutable(idOrName);
        dataAdapterDto.ifPresent(dataAdapter -> this.clusterEventBus.post(DataAdaptersDeleted.create(dataAdapter.id())));
    }

    public Collection<DataAdapterDto> findByIds(Set<String> idSet) {
        DBQuery.Query query = DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }

    public Collection<DataAdapterDto> findAll() {
        try (DBCursor cursor = this.db.find();){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }
}

