/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.time.ZonedDateTime;
import java.util.Set;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.migrations.AutoValue_V20161215163900_MoveIndexSetDefaultConfig_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161215163900_MoveIndexSetDefaultConfig
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161215163900_MoveIndexSetDefaultConfig.class);
    private static final String FIELD_DEFAULT = "default";
    private static final String FIELD_CREATION_DATE = "creation_date";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_ID = "_id";
    private final MongoCollection<Document> collection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20161215163900_MoveIndexSetDefaultConfig(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.collection = mongoConnection.getMongoDatabase().getCollection("index_sets");
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-12-15T16:39:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already done.");
            return;
        }
        boolean defaultDone = this.clusterConfigService.get(DefaultIndexSetConfig.class) != null;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FindIterable documents = this.collection.find(Filters.exists((String)FIELD_DEFAULT)).sort(Sorts.ascending((String[])new String[]{FIELD_CREATION_DATE}));
        for (Document document : documents) {
            long modifiedCount;
            ObjectId id = document.getObjectId((Object)FIELD_ID);
            String idString = id.toHexString();
            boolean isDefault = (Boolean)MoreObjects.firstNonNull((Object)document.getBoolean((Object)FIELD_DEFAULT), (Object)false);
            if (!defaultDone && isDefault) {
                defaultDone = true;
                this.clusterConfigService.write(DefaultIndexSetConfig.create(idString));
            }
            if ((modifiedCount = this.collection.updateOne(Filters.eq((String)FIELD_ID, (Object)id), Updates.unset((String)FIELD_DEFAULT)).getMatchedCount()) > 0L) {
                LOG.info("Removed <default> field from index set <{}> ({})", (Object)document.getString((Object)FIELD_TITLE), (Object)idString);
                builder.add((Object)idString);
                continue;
            }
            LOG.error("Couldn't remove <default> field from index set <{}> ({})", (Object)document.getString((Object)FIELD_TITLE), (Object)idString);
        }
        this.clusterConfigService.write(MigrationCompleted.create((Set<String>)builder.build()));
    }

    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="index_set_ids")
        public abstract Set<String> indexSetIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="index_set_ids") Set<String> indexSetIds) {
            return new AutoValue_V20161215163900_MoveIndexSetDefaultConfig_MigrationCompleted(indexSetIds);
        }
    }
}

