/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration.fields;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog2.plugin.configuration.fields.AbstractConfigurationField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.shared.SuppressForbidden;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class DropdownField
extends AbstractConfigurationField {
    public static final String FIELD_TYPE = "dropdown";
    private String defaultValue;
    private final Map<String, String> values;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;

    public DropdownField(String name, String humanName, String defaultValue, Map<String, String> values, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, values, null, isOptional);
    }

    public DropdownField(String name, String humanName, String defaultValue, Map<String, String> values, String description, ConfigurationField.Optional isOptional) {
        super(FIELD_TYPE, name, humanName, description, isOptional);
        this.defaultValue = defaultValue;
        this.values = values;
    }

    public DropdownField(String name, String humanName, String defaultValue, Map<String, String> values, String description, ConfigurationField.Optional isOptional, int position) {
        this(name, humanName, defaultValue, values, description, isOptional);
        this.position = position;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        if (defaultValue instanceof String) {
            this.defaultValue = (String)defaultValue;
        }
    }

    @Override
    public Map<String, Map<String, String>> getAdditionalInformation() {
        HashMap result = Maps.newHashMap();
        result.put("values", this.values);
        return result;
    }

    public static class ValueTemplates {
        public static Map<String, String> timeUnits() {
            HashMap units = Maps.newHashMap();
            for (TimeUnit unit : TimeUnit.values()) {
                String human = unit.toString().toLowerCase(Locale.ENGLISH);
                units.put(unit.toString(), Character.toUpperCase(human.charAt(0)) + human.substring(1));
            }
            return units;
        }

        public static Map<String, String> timeZones() {
            Map<Integer, List<DateTimeZone>> offsetsAndTimezones = ValueTemplates.buildSortedTimeZoneMap();
            LinkedHashMap<String, String> timezones = new LinkedHashMap<String, String>();
            for (List<DateTimeZone> dtzList : offsetsAndTimezones.values()) {
                for (DateTimeZone dtz : dtzList) {
                    timezones.put(dtz.getID(), ValueTemplates.buildTimeZoneDisplayName(dtz));
                }
            }
            return timezones;
        }

        public static Map<String, String> valueMapFromEnum(Class<? extends Enum> enumClass, Function<Enum, String> valueMapping) {
            return Arrays.stream(enumClass.getEnumConstants()).collect(Collectors.toMap(Enum::toString, valueMapping));
        }

        @SuppressForbidden(value="Intentionally use system default timezone")
        private static Map<Integer, List<DateTimeZone>> buildSortedTimeZoneMap() {
            List dtzList = DateTimeZone.getAvailableIDs().stream().map(DateTimeZone::forID).sorted(Comparator.comparing(DateTimeZone::getID, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
            TreeMap<Integer, List<DateTimeZone>> offsetsAndTimezones = new TreeMap<Integer, List<DateTimeZone>>();
            Instant now = new DateTime(DateTimeZone.getDefault()).toInstant();
            for (DateTimeZone dtz : dtzList) {
                int rawOffset = dtz.getOffset((ReadableInstant)now);
                List timezonesForOffset = offsetsAndTimezones.getOrDefault(rawOffset, new ArrayList());
                timezonesForOffset.add(dtz);
                offsetsAndTimezones.put(rawOffset, timezonesForOffset);
            }
            return offsetsAndTimezones;
        }

        @SuppressForbidden(value="Intentionally use system default timezone")
        private static String buildTimeZoneDisplayName(DateTimeZone dtz) {
            Instant now = new DateTime(DateTimeZone.getDefault()).toInstant();
            int offset = dtz.getOffset((ReadableInstant)now);
            int offsetHours = offset / 3600000;
            int remainderOffset = offset % 3600000;
            if (remainderOffset < 0) {
                remainderOffset *= -1;
            }
            int offsetMinutes = remainderOffset / 60000;
            return String.format(Locale.getDefault(), "UTC%+03d:%02d - %s", offsetHours, offsetMinutes, dtz.getID());
        }
    }
}

