/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.util;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class ConnectionCounter
extends ChannelInboundHandlerAdapter {
    private final AtomicInteger connections;
    private final AtomicLong totalConnections;

    public ConnectionCounter(AtomicInteger connections, AtomicLong totalConnections) {
        this.connections = connections;
        this.totalConnections = totalConnections;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.connections.incrementAndGet();
        this.totalConnections.incrementAndGet();
        ctx.channel().closeFuture().addListener(f -> this.connections.decrementAndGet());
        super.channelActive(ctx);
    }

    public int getConnectionCount() {
        return this.connections.get();
    }

    public long getTotalConnections() {
        return this.totalConnections.get();
    }
}

