/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.SearchExecutor;
import org.graylog.plugins.views.search.filter.QueryStringFilter;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.ResultChunk;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    protected static final String DEFAULT_SCROLL_BATCH_SIZE = "500";
    protected final Searches searches;
    private final ClusterConfigService clusterConfigService;
    private final DecoratorProcessor decoratorProcessor;
    private final SearchExecutor searchExecutor;

    public SearchResource(Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor, SearchExecutor searchExecutor) {
        this.searches = searches;
        this.clusterConfigService = clusterConfigService;
        this.decoratorProcessor = decoratorProcessor;
        this.searchExecutor = searchExecutor;
    }

    protected SearchResponse search(String query, int limit, int offset, String filter, boolean decorate, SearchUser searchUser, List<String> fieldList, Sort sorting, TimeRange timeRange) {
        Search search = this.createSearch(query, limit, offset, filter, fieldList, sorting, timeRange);
        Optional<String> streamId = Searches.extractStreamId(filter);
        SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
        return this.extractSearchResponse(searchJob, query, decorate, fieldList, timeRange, streamId);
    }

    protected List<String> parseFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            LOG.warn("Missing fields parameter. Returning HTTP 400");
            throw new BadRequestException("Missing required parameter `fields`");
        }
        return this.parseOptionalFields(fields);
    }

    protected List<String> parseOptionalFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            return null;
        }
        Iterable split = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)fields);
        ArrayList fieldList = Lists.newArrayList((Object[])new String[]{"timestamp"});
        for (String field : split) {
            if ("timestamp".equals(field)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    protected SearchResponse buildSearchResponse(SearchResult sr, TimeRange timeRange, boolean decorate, Optional<String> streamId) {
        SearchResponse result = SearchResponse.create(sr.getOriginalQuery(), sr.getBuiltQuery(), this.indexRangeListToValueList(sr.getUsedIndices()), this.resultMessageListtoValueList(sr.getResults()), sr.getFields(), sr.tookMs(), sr.getTotalResults(), timeRange.getFrom(), timeRange.getTo());
        return decorate ? this.decoratorProcessor.decorate(result, streamId) : result;
    }

    protected SearchResponse buildSearchResponse(String query, MessageList.Result results, List<String> fieldList, long tookMs, TimeRange timeRange, boolean decorate, Optional<String> streamId) {
        SearchResponse result = SearchResponse.create(query, query, Collections.emptySet(), results.messages(), (Set<String>)(fieldList == null ? Collections.emptySet() : ImmutableSet.copyOf(fieldList)), tookMs, results.totalResults(), timeRange.getFrom(), timeRange.getTo());
        return decorate ? this.decoratorProcessor.decorate(result, streamId) : result;
    }

    protected Set<IndexRangeSummary> indexRangeListToValueList(Set<IndexRange> indexRanges) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)indexRanges.size());
        for (IndexRange indexRange : indexRanges) {
            result.add(IndexRangeSummary.create(indexRange.indexName(), indexRange.begin(), indexRange.end(), indexRange.calculatedAt(), indexRange.calculationDuration()));
        }
        return result;
    }

    protected List<ResultMessageSummary> resultMessageListtoValueList(List<ResultMessage> resultMessages) {
        return resultMessages.stream().map(resultMessage -> ResultMessageSummary.create(resultMessage.highlightRanges, resultMessage.getMessage().getFields(), resultMessage.getIndex())).collect(Collectors.toList());
    }

    protected Sorting buildSorting(String sort) {
        if (Strings.isNullOrEmpty((String)sort)) {
            return Sorting.DEFAULT;
        }
        try {
            return Sorting.fromApiParam(sort);
        }
        catch (Exception e) {
            LOG.error("Falling back to default sorting.", (Throwable)e);
            return Sorting.DEFAULT;
        }
    }

    protected Sort buildSortOrder(String sort) {
        if (Strings.isNullOrEmpty((String)sort)) {
            return Sort.create("timestamp", Sort.Order.DESC);
        }
        if (!sort.contains(":")) {
            throw new IllegalArgumentException("Invalid sorting parameter: " + sort);
        }
        String[] parts = sort.split(":");
        return Sort.create(parts[0], Sort.Order.valueOf(parts[1].toUpperCase(Locale.ENGLISH)));
    }

    protected Search createSearch(String queryString, int limit, int offset, String filter, List<String> fieldList, Sort sorting, TimeRange timeRange) {
        SearchType searchType = this.createMessageList(sorting, limit, offset, fieldList);
        Query query = Query.builder().query(ElasticsearchQueryString.of(queryString)).filter(QueryStringFilter.builder().query(Strings.isNullOrEmpty((String)filter) ? "*" : filter).build()).timerange(timeRange).searchTypes(Collections.singleton(searchType)).build();
        return Search.Builder.create().queries((ImmutableSet<Query>)ImmutableSet.of((Object)query)).build();
    }

    private SearchType createMessageList(Sort sorting, int limit, int offset, List<String> fieldList) {
        MessageList.Builder messageListBuilder = MessageList.builder().sort(Collections.singletonList(sorting));
        messageListBuilder = limit > 0 ? messageListBuilder.limit(limit) : messageListBuilder;
        messageListBuilder = offset > 0 ? messageListBuilder.offset(offset) : messageListBuilder;
        messageListBuilder = fieldList != null && !fieldList.isEmpty() ? messageListBuilder.fields(fieldList) : messageListBuilder;
        return messageListBuilder.build();
    }

    protected SearchResponse extractSearchResponse(SearchJob searchJob, String query, boolean decorate, List<String> fieldList, TimeRange timeRange, Optional<String> streamId) {
        QueryResult queryResult = searchJob.results().values().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing query result"));
        MessageList.Result result = queryResult.searchTypes().values().stream().findFirst().map(searchTypeResult -> (MessageList.Result)searchTypeResult).orElseThrow(() -> new IllegalStateException("Missing search type result!"));
        long tookMs = queryResult.executionStats().duration();
        return this.buildSearchResponse(query, result, fieldList, tookMs, timeRange, decorate, streamId);
    }

    protected ChunkedOutput<ResultChunk> buildChunkedOutput(ScrollResult scroll) {
        ChunkedOutput output = new ChunkedOutput(ResultChunk.class);
        LOG.debug("[{}] Scroll result contains a total of {} messages", (Object)scroll.getQueryHash(), (Object)scroll.totalHits());
        Runnable scrollIterationAction = this.createScrollChunkProducer(scroll, (ChunkedOutput<ResultChunk>)output);
        new Thread(scrollIterationAction).start();
        return output;
    }

    public void checkSearchPermission(String filter, String searchPermission) {
        if (Strings.isNullOrEmpty((String)filter) || "*".equals(filter)) {
            this.checkPermission(searchPermission);
        } else {
            if (!filter.startsWith("streams:")) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String[] parts = filter.split(":");
            if (parts.length <= 1) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String streamList = parts[1];
            String[] streams = streamList.split(",");
            if (streams.length == 0) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            for (String streamId : streams) {
                if (this.isPermitted("streams:read", streamId)) continue;
                String msg = "Not allowed to search with filter: [" + filter + "]. (Forbidden stream: " + streamId + ")";
                LOG.warn(msg);
                throw new ForbiddenException(msg);
            }
        }
    }

    protected Runnable createScrollChunkProducer(ScrollResult scroll, ChunkedOutput<ResultChunk> output) {
        return () -> {
            try {
                ResultChunk chunk = scroll.nextChunk();
                while (chunk != null) {
                    LOG.debug("[{}] Writing scroll chunk with {} messages", (Object)scroll.getQueryHash(), (Object)chunk.messages().size());
                    if (output.isClosed()) {
                        LOG.debug("[{}] Client connection is closed, client disconnected. Aborting scroll.", (Object)scroll.getQueryHash());
                        scroll.cancel();
                        return;
                    }
                    output.write((Object)chunk);
                    chunk = scroll.nextChunk();
                }
                LOG.debug("[{}] Reached end of scroll result.", (Object)scroll.getQueryHash());
                output.close();
            }
            catch (IOException e) {
                LOG.warn("[{}] Could not close chunked output stream for query scroll.", (Object)scroll.getQueryHash());
            }
        };
    }

    protected TimeRange restrictTimeRange(TimeRange timeRange) {
        DateTime limitedFrom;
        DateTime originalFrom = timeRange.getFrom();
        DateTime to = timeRange.getTo();
        SearchesClusterConfig config = this.clusterConfigService.get(SearchesClusterConfig.class);
        DateTime from = config == null || Period.ZERO.equals((Object)config.queryTimeRangeLimit()) ? originalFrom : ((limitedFrom = to.minus((ReadablePeriod)config.queryTimeRangeLimit())).isAfter((ReadableInstant)originalFrom) ? limitedFrom : originalFrom);
        return AbsoluteRange.create(from, to);
    }
}

