/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.shared.events.DeadEventLoggingListener;

public class EventBusProvider
implements Provider<EventBus> {
    private final BaseConfiguration configuration;
    private final MetricRegistry metricRegistry;

    @Inject
    public EventBusProvider(BaseConfiguration configuration, MetricRegistry metricRegistry) {
        this.configuration = configuration;
        this.metricRegistry = metricRegistry;
    }

    public EventBus get() {
        AsyncEventBus eventBus = new AsyncEventBus("graylog-eventbus", (Executor)this.executorService(this.configuration.getAsyncEventbusProcessors()));
        eventBus.register((Object)new DeadEventLoggingListener());
        return eventBus;
    }

    private ExecutorService executorService(int nThreads) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("eventbus-handler-%d").build();
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads, threadFactory), this.metricRegistry, MetricRegistry.name(this.getClass(), (String[])new String[]{"executor-service"}));
    }
}

