/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.providers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class AtomicCache<T> {
    private final AtomicReference<Future<T>> value = new AtomicReference();

    public T get(Supplier<T> valueSupplier) throws ExecutionException, InterruptedException {
        CompletableFuture<T> completableFuture = new CompletableFuture<T>();
        Future previous = this.value.getAndAccumulate(completableFuture, (prev, cur) -> prev == null ? cur : prev);
        if (previous == null) {
            try {
                T newValue = valueSupplier.get();
                completableFuture.complete(newValue);
                return newValue;
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                return null;
            }
        }
        return (T)previous.get();
    }
}

