/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.google.inject.Inject;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.lookup.LookupTableService;

public class LookupAddStringList
extends AbstractFunction<Object> {
    public static final String NAME = "lookup_add_string_list";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to add the given list").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to add in the lookup table").build();
    private final ParameterDescriptor<List, List> valueParam = ParameterDescriptor.type("value", List.class).description("The list value that should be added into the lookup table").build();
    private final ParameterDescriptor<Boolean, Boolean> keepDuplicates = ParameterDescriptor.bool("keep_duplicates").optional().description("When adding values to an existing list, don't try to omit duplicates. Default is false").build();

    @Inject
    public LookupAddStringList(LookupTableService lookupTableService) {
    }

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return null;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return null;
        }
        List value = this.valueParam.required(args, context);
        if (value == null) {
            return null;
        }
        boolean keepDupes = this.keepDuplicates.optional(args, context).orElse(false);
        return table.addStringList(key, value, keepDupes).stringListValue();
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Add a string list in the named lookup table. Returns the updated list on success, null on failure.").params(this.lookupTableParam, this.keyParam, this.valueParam, this.keepDuplicates).returnType(List.class).build();
    }
}

