/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.UsesSearchFilters;
import org.graylog.plugins.views.search.views.$AutoValue_WidgetDTO;
import org.graylog.plugins.views.search.views.UnknownWidgetConfigDTO;
import org.graylog.plugins.views.search.views.WidgetConfigDTO;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.WidgetEntity;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class WidgetDTO
implements ContentPackable<WidgetEntity>,
UsesSearchFilters {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_FILTER = "filter";
    public static final String FIELD_SEARCH_FILTERS = "filters";
    public static final String FIELD_CONFIG = "config";
    public static final String FIELD_TIMERANGE = "timerange";
    public static final String FIELD_QUERY = "query";
    public static final String FIELD_STREAMS = "streams";

    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="type")
    public abstract String type();

    @JsonProperty(value="filter")
    @Nullable
    public abstract String filter();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty(value="timerange")
    public abstract Optional<TimeRange> timerange();

    @JsonProperty(value="query")
    public abstract Optional<BackendQuery> query();

    @JsonProperty(value="streams")
    public abstract Set<String> streams();

    @JsonProperty(value="config")
    public abstract WidgetConfigDTO config();

    public static Builder builder() {
        return Builder.builder();
    }

    public abstract Builder toBuilder();

    @Override
    public WidgetEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        Set<String> mappedStreams = this.streams().stream().map(streamId -> entityDescriptorIds.get(EntityDescriptor.create(streamId, ModelTypes.STREAM_V1))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        WidgetEntity.Builder builder = WidgetEntity.builder().id(this.id()).config(this.config()).filter(this.filter()).filters(this.filters()).streams(mappedStreams).type(this.type());
        if (this.query().isPresent()) {
            builder.query(this.query().get());
        }
        if (this.timerange().isPresent()) {
            builder.timerange(this.timerange().get());
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(String var1);

        @JsonProperty(value="filter")
        public abstract Builder filter(@Nullable String var1);

        @JsonProperty(value="filters")
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty(value="timerange")
        public abstract Builder timerange(@Nullable TimeRange var1);

        @JsonProperty(value="query")
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="config")
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type", visible=true, defaultImpl=UnknownWidgetConfigDTO.class)
        public abstract Builder config(WidgetConfigDTO var1);

        public abstract WidgetDTO build();

        @JsonCreator
        static Builder builder() {
            return new $AutoValue_WidgetDTO.Builder().streams(Collections.emptySet()).filters(Collections.emptyList());
        }
    }
}

