/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.entities;

import java.util.Objects;
import java.util.Optional;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedEntity;

public abstract class ScopedDbService<E extends ScopedEntity>
extends PaginatedDbService<E> {
    protected final EntityScopeService entityScopeService;

    public ScopedDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Class<E> dtoClass, String collectionName, EntityScopeService entityScopeService) {
        super(mongoConnection, mapper, dtoClass, collectionName);
        this.entityScopeService = entityScopeService;
    }

    public final boolean isMutable(ScopedEntity scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        Optional current = this.get(scopedEntity.id());
        if (current.isPresent()) {
            return this.entityScopeService.isMutable((ScopedEntity)current.get());
        }
        return this.entityScopeService.isMutable(scopedEntity);
    }

    @Override
    public final E save(E entity) {
        this.ensureValidScope(entity);
        if (((ScopedEntity)entity).id() != null) {
            this.ensureMutability(entity);
        }
        return (E)((ScopedEntity)super.save(entity));
    }

    public final void ensureValidScope(E entity) {
        if (!this.entityScopeService.hasValidScope((ScopedEntity)entity)) {
            throw new IllegalArgumentException("Invalid Entity Scope: " + ((ScopedEntity)entity).scope());
        }
    }

    public final void ensureMutability(E entity) {
        if (!this.isMutable((ScopedEntity)entity)) {
            throw new IllegalArgumentException("Immutable entity cannot be modified");
        }
    }

    @Override
    public final int delete(String id) {
        this.ensureMutability((ScopedEntity)this.get(id).orElseThrow(() -> new IllegalArgumentException("Entity not found")));
        return super.delete(id);
    }

    public final int deleteImmutable(String id) {
        return super.delete(id);
    }
}

