/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.strategies.AbstractIndexCountBasedRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategyConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionRetentionStrategy
extends AbstractIndexCountBasedRetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionRetentionStrategy.class);
    private final Indices indices;
    private final NodeId nodeId;
    private final AuditEventSender auditEventSender;

    @Inject
    public DeletionRetentionStrategy(Indices indices, ActivityWriter activityWriter, NodeId nodeId, AuditEventSender auditEventSender) {
        super(indices, activityWriter);
        this.indices = indices;
        this.nodeId = nodeId;
        this.auditEventSender = auditEventSender;
    }

    @Override
    protected Optional<Integer> getMaxNumberOfIndices(IndexSet indexSet) {
        IndexSetConfig indexSetConfig = indexSet.getConfig();
        RetentionStrategyConfig strategyConfig = indexSetConfig.retentionStrategy();
        if (!(strategyConfig instanceof DeletionRetentionStrategyConfig)) {
            throw new IllegalStateException("Invalid retention strategy config <" + strategyConfig.getClass().getCanonicalName() + "> for index set <" + indexSetConfig.id() + ">");
        }
        DeletionRetentionStrategyConfig config = (DeletionRetentionStrategyConfig)strategyConfig;
        return Optional.of(config.maxNumberOfIndices());
    }

    @Override
    public void retain(List<String> indexNames, IndexSet indexSet) {
        indexNames.forEach(indexName -> {
            Stopwatch sw = Stopwatch.createStarted();
            this.indices.delete((String)indexName);
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_retention:delete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"retention_strategy", (Object)this.getClass().getCanonicalName()));
            LOG.info("Finished index retention strategy [delete] for index <{}> in {}ms.", indexName, (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        });
    }

    @Override
    public Class<? extends RetentionStrategyConfig> configurationClass() {
        return DeletionRetentionStrategyConfig.class;
    }

    @Override
    public RetentionStrategyConfig defaultConfiguration() {
        return DeletionRetentionStrategyConfig.createDefault();
    }
}

