/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.resources.system.RemoteLookupTableResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Cluster/LookupTable", tags={"cloud"})
@Path(value="/cluster/system/lookup")
@Produces(value={"application/json"})
public class ClusterLookupTableResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterLookupTableResource.class);

    @Inject
    public ClusterLookupTableResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @POST
    @Timed
    @Path(value="tables/{idOrName}/purge")
    @ApiOperation(value="Purge Lookup Table Cache on the cluster-wide level")
    @NoAuditEvent(value="Cache purge only")
    @RequiresPermissions(value={"lookuptables:read"})
    public Map<String, ProxiedResource.CallResult<Void>> performPurge(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @ApiParam(name="key") @QueryParam(value="key") String key) {
        return this.requestOnAllNodes(this.createRemoteInterfaceProvider(RemoteLookupTableResource.class), client -> client.performPurge(idOrName, key));
    }
}

