/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.DuplicateKeyException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSessionDAO
extends CachingSessionDAO {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbSessionDAO.class);
    private final MongoDBSessionService mongoDBSessionService;

    @Inject
    public MongoDbSessionDAO(MongoDBSessionService mongoDBSessionService) {
        this.mongoDBSessionService = mongoDBSessionService;
    }

    protected Serializable doCreate(Session session) {
        Serializable id = this.generateSessionId(session);
        this.assignSessionId(session, id);
        HashMap fields = Maps.newHashMap();
        fields.put("session_id", id);
        fields.put("host", session.getHost());
        fields.put("start_timestamp", session.getStartTimestamp());
        fields.put("last_access_time", session.getLastAccessTime());
        fields.put("timeout", session.getTimeout());
        HashMap attributes = Maps.newHashMap();
        for (Object key : session.getAttributeKeys()) {
            attributes.put(key.toString(), session.getAttribute(key));
        }
        fields.put("attributes", attributes);
        MongoDbSession dbSession = new MongoDbSession(fields);
        String objectId = this.mongoDBSessionService.saveWithoutValidation(dbSession);
        LOG.debug("Created session {}", (Object)objectId);
        return id;
    }

    protected Session doReadSession(Serializable sessionId) {
        MongoDbSession dbSession = this.mongoDBSessionService.load(sessionId.toString());
        if (dbSession == null) {
            return null;
        }
        return this.getSimpleSession(sessionId, dbSession);
    }

    private SimpleSession getSimpleSession(Serializable sessionId, MongoDbSession dbSession) {
        SimpleSession session = new SimpleSession();
        this.assignSessionId((Session)session, sessionId);
        session.setHost(dbSession.getHost());
        session.setTimeout(dbSession.getTimeout());
        session.setStartTimestamp(dbSession.getStartTimestamp());
        session.setLastAccessTime(dbSession.getLastAccessTime());
        session.setExpired(dbSession.isExpired());
        session.setAttributes(dbSession.getAttributes());
        return session;
    }

    protected void doUpdate(Session session) {
        MongoDbSession dbSession = this.mongoDBSessionService.load(session.getId().toString());
        if (null == dbSession) {
            throw new RuntimeException("Couldn't load session");
        }
        LOG.debug("Updating session");
        dbSession.setHost(session.getHost());
        dbSession.setTimeout(session.getTimeout());
        dbSession.setStartTimestamp(session.getStartTimestamp());
        dbSession.setLastAccessTime(session.getLastAccessTime());
        if (!(session instanceof SimpleSession)) {
            throw new RuntimeException("Unsupported session type: " + session.getClass().getCanonicalName());
        }
        SimpleSession simpleSession = (SimpleSession)session;
        dbSession.setAttributes(simpleSession.getAttributes());
        dbSession.setExpired(simpleSession.isExpired());
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(DuplicateKeyException.class).withWaitStrategy(WaitStrategies.randomWait((long)5L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)10)).build();
        try {
            retryer.call(() -> this.mongoDBSessionService.saveWithoutValidation(dbSession));
        }
        catch (ExecutionException e) {
            LOG.warn("Unexpected exception when saving session to MongoDB. Failed to update session.", (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
        catch (RetryException e) {
            LOG.warn("Tried to update session 10 times, but still failed. This is likely because of https://jira.mongodb.org/browse/SERVER-14322", (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
    }

    protected void doDelete(Session session) {
        LOG.debug("Deleting session");
        Serializable id = session.getId();
        MongoDbSession dbSession = this.mongoDBSessionService.load(id.toString());
        if (dbSession != null) {
            int deleted = this.mongoDBSessionService.destroy(dbSession);
            LOG.debug("Deleted {} sessions from database", (Object)deleted);
        } else {
            LOG.debug("Session not found in database");
        }
    }

    public Collection<Session> getActiveSessions() {
        LOG.debug("Retrieving all active sessions.");
        Collection<MongoDbSession> dbSessions = this.mongoDBSessionService.loadAll();
        ArrayList sessions = Lists.newArrayList();
        for (MongoDbSession dbSession : dbSessions) {
            sessions.add(this.getSimpleSession((Serializable)((Object)dbSession.getSessionId()), dbSession));
        }
        return sessions;
    }
}

