/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.template.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class IndentTemplateDirective
implements TemplateDirectiveModel {
    private static final String PARAM_NAME_COUNT = "count";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        int countParam = 0;
        if (params.size() != 1) {
            throw new TemplateModelException("Provide 'count' parameter to use the @indent directive.");
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry parameter = entry = iterator.next();
            String paramName = (String)parameter.getKey();
            TemplateModel paramValue = (TemplateModel)parameter.getValue();
            if (!paramName.equals(PARAM_NAME_COUNT)) continue;
            if (!(paramValue instanceof TemplateNumberModel)) {
                throw new TemplateModelException("Parameter 'count' must be a number.");
            }
            countParam = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
            if (countParam >= 0) continue;
            throw new TemplateModelException("Parameter 'count' can't be negative.");
        }
        if (body == null) {
            throw new RuntimeException("Body is missing");
        }
        body.render((Writer)new IndentFilterWriter(countParam, env.getOut()));
    }

    private static class IndentFilterWriter
    extends Writer {
        private final int count;
        private final Writer out;

        IndentFilterWriter(int count, Writer out) {
            this.count = count;
            this.out = out;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String sbuf = String.valueOf(cbuf);
            sbuf = sbuf.replaceAll("\n", "\n" + String.join((CharSequence)"", Collections.nCopies(this.count, " ")));
            this.out.write(sbuf);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

