/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.filtering.DbQueryCreator;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.search.SearchQueryField;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Dashboards", tags={"cloud"})
@Produces(value={"application/json"})
@Path(value="/dashboards")
public class DashboardsResource
extends RestResource {
    private final ViewService dbService;
    private static final String DEFAULT_SORT_FIELD = "title";
    private static final String DEFAULT_SORT_DIRECTION = "asc";
    private static final List<EntityAttribute> attributes = List.of(EntityAttribute.builder().id("_id").title("id").type(SearchQueryField.Type.OBJECT_ID).hidden(true).searchable(true).build(), EntityAttribute.builder().id("title").title("Title").searchable(true).build(), EntityAttribute.builder().id("created_at").title("Created").type(SearchQueryField.Type.DATE).filterable(true).build(), EntityAttribute.builder().id("description").title("Description").searchable(true).build(), EntityAttribute.builder().id("summary").title("Summary").searchable(true).build(), EntityAttribute.builder().id("owner").title("Owner").build(), EntityAttribute.builder().id("favorite").title("Favorite").sortable(false).build());
    private static final EntityDefaults settings = EntityDefaults.builder().sort(Sorting.create("title", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();
    private final DbQueryCreator dbQueryCreator;

    @Inject
    public DashboardsResource(ViewService dbService) {
        this.dbService = dbService;
        this.dbQueryCreator = new DbQueryCreator(DEFAULT_SORT_FIELD, attributes);
    }

    @GET
    @ApiOperation(value="Get a list of all dashboards")
    @Timed
    public PageListResponse<ViewSummaryDTO> views(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="id,title,created_at,description,summary,owner") @DefaultValue(value="title") @QueryParam(value="sort") String sortField, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query, @ApiParam(name="filters") @QueryParam(value="filters") List<String> filters, @Context SearchUser searchUser) {
        if (!ViewDTO.SORT_FIELDS.contains((Object)sortField.toLowerCase(Locale.ENGLISH))) {
            sortField = DEFAULT_SORT_FIELD;
        }
        try {
            Bson dbQuery = this.dbQueryCreator.createDbQuery(filters, query);
            PaginatedList<ViewSummaryDTO> result = this.dbService.searchSummariesPaginatedByType(searchUser, ViewDTO.Type.DASHBOARD, dbQuery, searchUser::canReadView, order, sortField, page, perPage);
            return PageListResponse.create(query, result.pagination(), result.pagination().total(), sortField, order, result, attributes, settings);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

