/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.shares.AutoValue_Grantee;

@AutoValue
public abstract class Grantee {
    public static final String GRANTEE_TYPE_GLOBAL = "global";
    public static final String GRANTEE_TYPE_TEAM = "team";
    public static final String GRANTEE_TYPE_USER = "user";

    @JsonProperty(value="id")
    public abstract GRN grn();

    @JsonProperty(value="type")
    public abstract String type();

    @JsonProperty(value="title")
    public abstract String title();

    public static Grantee create(GRN grn, String type, String title) {
        return new AutoValue_Grantee(grn, type, title);
    }

    public static Grantee createGlobal() {
        return Grantee.create(GRNRegistry.GLOBAL_USER_GRN, GRANTEE_TYPE_GLOBAL, "Everyone");
    }

    public static Grantee createUser(GRN grn, String title) {
        return Grantee.create(grn, GRANTEE_TYPE_USER, title);
    }
}

