/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.graylog2.database.DbEntity;
import org.graylog2.decorators.;
import org.graylog2.decorators.Decorator;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@DbEntity(collection="decorators", titleField="", readPermission="decorators:read")
@AutoValue
public abstract class DecoratorImpl
implements Decorator,
Comparable {
    static final String FIELD_ID = "id";
    static final String FIELD_TYPE = "type";
    static final String FIELD_CONFIG = "config";
    static final String FIELD_STREAM = "stream";
    static final String FIELD_ORDER = "order";

    public int compareTo(Object o) {
        if (o instanceof Decorator) {
            Decorator decorator = (Decorator)o;
            return this.order() - decorator.order();
        }
        return 0;
    }

    @Override
    @JsonProperty(value="id")
    @Id
    @ObjectId
    @Nullable
    public abstract String id();

    @Override
    @JsonProperty(value="type")
    @NotBlank
    public abstract String type();

    @Override
    @JsonProperty(value="config")
    public abstract Map<String, Object> config();

    @Override
    @JsonProperty(value="stream")
    public abstract Optional<String> stream();

    @Override
    @JsonProperty(value="order")
    public abstract int order();

    public abstract Builder toBuilder();

    @JsonCreator
    public static DecoratorImpl create(@JsonProperty(value="id") @JsonAlias(value={"_id"}) @Id @ObjectId @Nullable String id, @JsonProperty(value="type") String type, @JsonProperty(value="config") Map<String, Object> config, @JsonProperty(value="stream") Optional<String> stream, @JsonProperty(value="order") int order) {
        return new .AutoValue_DecoratorImpl.Builder().id(id).type(type).config(config).stream(stream).order(order).build();
    }

    public static Decorator create(@JsonProperty(value="type") String type, @JsonProperty(value="config") Map<String, Object> config, @JsonProperty(value="stream") Optional<String> stream, @JsonProperty(value="order") int order) {
        return DecoratorImpl.create(null, type, config, stream, order);
    }

    public static Decorator create(@JsonProperty(value="type") String type, @JsonProperty(value="config") Map<String, Object> config, @JsonProperty(value="order") int order) {
        return DecoratorImpl.create(type, config, Optional.empty(), order);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        abstract Builder type(String var1);

        abstract Builder config(Map<String, Object> var1);

        abstract Builder stream(Optional<String> var1);

        abstract Builder order(int var1);

        public abstract DecoratorImpl build();
    }
}

